/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.types.ResolvedArrayType;
import com.fasterxml.classmate.types.ResolvedObjectType;
import com.fasterxml.classmate.types.ResolvedPrimitiveType;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.mangofactory.swagger.models.Collections;
import com.mangofactory.swagger.models.DefaultGenericTypeNamingStrategy;
import com.mangofactory.swagger.models.Enums;
import com.mangofactory.swagger.models.GenericTypeNamingStrategy;
import com.mangofactory.swagger.models.Types;
import com.mangofactory.swagger.models.dto.AllowableValues;
import com.wordnik.swagger.annotations.ApiModel;
import java.lang.reflect.Type;
import java.util.List;
import org.springframework.core.annotation.AnnotationUtils;

public class ResolvedTypes {
    private static GenericTypeNamingStrategy namingStrategy = new DefaultGenericTypeNamingStrategy();

    private ResolvedTypes() {
        throw new UnsupportedOperationException();
    }

    public static void setNamingStrategy(GenericTypeNamingStrategy strategy) {
        if (strategy != null) {
            namingStrategy = strategy;
        }
    }

    public static String typeName(ResolvedType type) {
        if (Collections.isContainerType(type)) {
            return Collections.containerType(type);
        }
        return ResolvedTypes.innerTypeName(type);
    }

    public static String responseTypeName(ResolvedType type) {
        if (Collections.isContainerType(type)) {
            return String.format("%s%s", Collections.containerType(type), ResolvedTypes.optionalContainerTypeQualifierForReturn(type));
        }
        return ResolvedTypes.innerTypeName(type);
    }

    public static String parameterTypeName(ResolvedType type) {
        if (Collections.isContainerType(type)) {
            return String.format("%s%s", Collections.containerType(type), ResolvedTypes.optionalContainerTypeQualifierForReturn(type));
        }
        return ResolvedTypes.innerTypeName(type);
    }

    public static String simpleQualifiedTypeName(ResolvedType type) {
        if (type instanceof ResolvedPrimitiveType) {
            Class primitiveType = type.getErasedType();
            return Types.typeNameFor(primitiveType);
        }
        if (type instanceof ResolvedArrayType) {
            return Types.typeNameFor(type.getArrayElementType().getErasedType());
        }
        return type.getErasedType().getName();
    }

    public static ResolvedType asResolved(TypeResolver typeResolver, Type type) {
        if (type instanceof ResolvedType) {
            return (ResolvedType)type;
        }
        return typeResolver.resolve(type, new Type[0]);
    }

    public static AllowableValues allowableValues(ResolvedType resolvedType) {
        return Enums.allowableValues(resolvedType.getErasedType());
    }

    private static String optionalContainerTypeQualifierForReturn(ResolvedType type) {
        if (type.isArray()) {
            if ("object".equals(ResolvedTypes.typeName(type.getArrayElementType()))) {
                return "";
            }
            return String.format("[%s]", ResolvedTypes.typeName(type.getArrayElementType()));
        }
        List typeParameters = type.getTypeParameters();
        Preconditions.checkArgument((typeParameters.size() <= 1 ? 1 : 0) != 0, (Object)"Expects container to have at most one generic parameter");
        if (typeParameters.size() == 0) {
            return "";
        }
        String qualifier = ResolvedTypes.innerTypeName((ResolvedType)typeParameters.get(0));
        if ("object".equals(qualifier)) {
            return "";
        }
        return String.format("[%s]", qualifier);
    }

    private static String innerTypeName(ResolvedType type) {
        if (type.getTypeParameters().size() > 0 && type.getErasedType().getTypeParameters().length > 0) {
            return ResolvedTypes.genericTypeName(type);
        }
        return (String)ResolvedTypes.apiModelValue(type.getErasedType()).or((Object)ResolvedTypes.simpleTypeName(type));
    }

    private static String genericTypeName(ResolvedType resolvedType) {
        Class erasedType = resolvedType.getErasedType();
        String simpleName = (String)Optional.fromNullable((Object)Types.typeNameFor(erasedType)).or(ResolvedTypes.apiModelValue(erasedType).or((Object)erasedType.getSimpleName()));
        StringBuilder sb = new StringBuilder(String.format("%s%s", simpleName, namingStrategy.getOpenGeneric()));
        boolean first = true;
        for (int index = 0; index < erasedType.getTypeParameters().length; ++index) {
            ResolvedType typeParam = (ResolvedType)resolvedType.getTypeParameters().get(index);
            if (first) {
                sb.append(ResolvedTypes.innerTypeName(typeParam));
                first = false;
                continue;
            }
            sb.append(String.format("%s%s", namingStrategy.getTypeListDelimiter(), ResolvedTypes.innerTypeName(typeParam)));
        }
        sb.append(namingStrategy.getCloseGeneric());
        return sb.toString();
    }

    private static String simpleTypeName(ResolvedType type) {
        String typeName;
        Class erasedType = type.getErasedType();
        if (type instanceof ResolvedPrimitiveType) {
            return Types.typeNameFor(erasedType);
        }
        if (erasedType.isEnum()) {
            return "string";
        }
        if (type instanceof ResolvedArrayType) {
            return String.format("Array%s%s%s", namingStrategy.getOpenGeneric(), ResolvedTypes.innerTypeName(type.getArrayElementType()), namingStrategy.getCloseGeneric());
        }
        if (type instanceof ResolvedObjectType && (typeName = Types.typeNameFor(erasedType)) != null) {
            return typeName;
        }
        return erasedType.getSimpleName();
    }

    private static Optional<String> apiModelValue(Class<?> type) {
        ApiModel annotation = (ApiModel)AnnotationUtils.findAnnotation(type, ApiModel.class);
        if (annotation != null) {
            return Optional.fromNullable((Object)Strings.emptyToNull((String)annotation.value()));
        }
        return Optional.absent();
    }
}

