/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models.property;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.mangofactory.swagger.models.dto.AllowableListValues;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.List;

public final class ApiModelProperties {
    private ApiModelProperties() {
        throw new UnsupportedOperationException();
    }

    public static Function<ApiModelProperty, AllowableListValues> toAllowableList() {
        return new Function<ApiModelProperty, AllowableListValues>(){

            public AllowableListValues apply(ApiModelProperty annotation) {
                List allowableValues = Splitter.on((char)',').omitEmptyStrings().splitToList((CharSequence)Strings.nullToEmpty((String)annotation.allowableValues()));
                return new AllowableListValues(allowableValues, "LIST");
            }
        };
    }

    public static Function<ApiModelProperty, Boolean> toIsRequired() {
        return new Function<ApiModelProperty, Boolean>(){

            public Boolean apply(ApiModelProperty annotation) {
                return annotation.required();
            }
        };
    }

    public static Function<ApiModelProperty, String> toDescription() {
        return new Function<ApiModelProperty, String>(){

            public String apply(ApiModelProperty annotation) {
                String description = "";
                if (!Strings.isNullOrEmpty((String)annotation.value())) {
                    description = annotation.value();
                } else if (!Strings.isNullOrEmpty((String)annotation.notes())) {
                    description = annotation.notes();
                }
                return description;
            }
        };
    }

    public static Function<ApiModelProperty, Integer> toPosition() {
        return new Function<ApiModelProperty, Integer>(){

            public Integer apply(ApiModelProperty annotation) {
                return annotation.position();
            }
        };
    }

    public static Function<ApiModelProperty, Boolean> toHidden() {
        return new Function<ApiModelProperty, Boolean>(){

            public Boolean apply(ApiModelProperty annotation) {
                return annotation.hidden();
            }
        };
    }
}

