/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models.property;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Optional;
import com.mangofactory.swagger.models.ModelContext;
import com.mangofactory.swagger.models.ResolvedTypes;
import com.mangofactory.swagger.models.alternates.AlternateTypeProvider;
import com.mangofactory.swagger.models.dto.AllowableListValues;
import com.mangofactory.swagger.models.dto.AllowableValues;
import com.mangofactory.swagger.models.property.ApiModelProperties;
import com.mangofactory.swagger.models.property.ModelProperty;
import com.wordnik.swagger.annotations.ApiModelProperty;

public abstract class BaseModelProperty
implements ModelProperty {
    private final Optional<ApiModelProperty> apiModelProperty;
    private final String name;
    private final AlternateTypeProvider alternateTypeProvider;

    public BaseModelProperty(String name, AlternateTypeProvider alternateTypeProvider, Optional<ApiModelProperty> apiModelProperty) {
        this.name = name;
        this.apiModelProperty = apiModelProperty;
        this.alternateTypeProvider = alternateTypeProvider;
    }

    protected abstract ResolvedType realType();

    @Override
    public ResolvedType getType() {
        return this.alternateTypeProvider.alternateFor(this.realType());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String qualifiedTypeName() {
        if (this.getType().getTypeParameters().size() > 0) {
            return this.getType().toString();
        }
        return ResolvedTypes.simpleQualifiedTypeName(this.getType());
    }

    @Override
    public String typeName(ModelContext modelContext) {
        return ResolvedTypes.typeName(this.getType());
    }

    @Override
    public AllowableValues allowableValues() {
        Optional allowableValues = Optional.fromNullable((Object)ResolvedTypes.allowableValues(this.getType()));
        Optional listValues = this.apiModelProperty.transform(ApiModelProperties.toAllowableValues());
        if (allowableValues.isPresent()) {
            return (AllowableValues)allowableValues.get();
        }
        if (this.allowableValuesIsEmpty((Optional<AllowableValues>)listValues)) {
            return null;
        }
        return (AllowableValues)listValues.orNull();
    }

    private boolean allowableValuesIsEmpty(Optional<AllowableValues> allowableValues) {
        if (allowableValues.isPresent()) {
            AllowableValues allowable = (AllowableValues)allowableValues.get();
            return allowable instanceof AllowableListValues && ((AllowableListValues)allowable).getValues().size() == 0;
        }
        return true;
    }

    @Override
    public boolean isRequired() {
        return (Boolean)this.apiModelProperty.transform(ApiModelProperties.toIsRequired()).or((Object)false);
    }

    @Override
    public boolean isHidden() {
        return (Boolean)this.apiModelProperty.transform(ApiModelProperties.toHidden()).or((Object)false);
    }

    @Override
    public String propertyDescription() {
        return (String)this.getApiModelProperty().transform(ApiModelProperties.toDescription()).orNull();
    }

    protected Optional<ApiModelProperty> getApiModelProperty() {
        return this.apiModelProperty;
    }

    @Override
    public int position() {
        return (Integer)this.apiModelProperty.transform(ApiModelProperties.toPosition()).or((Object)0);
    }
}

