/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.springmvc;

import com.google.common.collect.Maps;
import com.mangofactory.swagger.ControllerDocumentation;
import com.mangofactory.swagger.SwaggerConfiguration;
import com.mangofactory.swagger.springmvc.ApiMethodReader;
import com.mangofactory.swagger.springmvc.MvcApiResource;
import com.wordnik.swagger.core.Documentation;
import com.wordnik.swagger.core.DocumentationEndPoint;
import com.wordnik.swagger.core.DocumentationOperation;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MvcApiReader {
    private static final Logger log = LoggerFactory.getLogger(MvcApiReader.class);
    private final WebApplicationContext context;
    private final SwaggerConfiguration config;
    private Map<String, HandlerMapping> handlerMappingBeans;
    private Documentation resourceListing;
    private final Map<Class<?>, DocumentationEndPoint> resourceListCache = Maps.newHashMap();
    private final Map<Class<?>, ControllerDocumentation> apiCache = Maps.newHashMap();

    public MvcApiReader(WebApplicationContext context, SwaggerConfiguration swaggerConfiguration) {
        this.context = context;
        this.config = swaggerConfiguration;
        this.handlerMappingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.context, HandlerMapping.class, (boolean)true, (boolean)false);
        this.buildMappingDocuments();
    }

    private void buildMappingDocuments() {
        this.resourceListing = this.config.newDocumentation();
        log.debug("Discovered {} candidates for documentation", (Object)this.handlerMappingBeans.size());
        for (HandlerMapping handlerMapping : this.handlerMappingBeans.values()) {
            if (RequestMappingHandlerMapping.class.isAssignableFrom(handlerMapping.getClass())) {
                this.processMethod((RequestMappingHandlerMapping)handlerMapping);
                continue;
            }
            log.debug("Not documenting mapping of type {}, as it is not of a recognized type.", (Object)handlerMapping.getClass().getName());
        }
    }

    private void addApiListingIfMissing(MvcApiResource resource) {
        if (this.resourceListCache.containsKey(resource.getControllerClass())) {
            return;
        }
        DocumentationEndPoint endpoint = resource.describeAsEndpoint();
        if (endpoint != null) {
            this.resourceListCache.put(resource.getControllerClass(), endpoint);
            log.debug("Added resource listing: {}", (Object)resource.toString());
            this.resourceListing.addApi(endpoint);
        }
    }

    private void processMethod(RequestMappingHandlerMapping handlerMapping) {
        for (Map.Entry entry : handlerMapping.getHandlerMethods().entrySet()) {
            HandlerMethod handlerMethod = (HandlerMethod)entry.getValue();
            RequestMappingInfo mappingInfo = (RequestMappingInfo)entry.getKey();
            MvcApiResource resource = new MvcApiResource(handlerMethod, this.config);
            if (resource.isInternalResource()) continue;
            this.addApiListingIfMissing(resource);
            ControllerDocumentation apiDocumentation = this.getApiDocumentation(resource);
            for (String requestUri : mappingInfo.getPatternsCondition().getPatterns()) {
                DocumentationEndPoint endPoint = apiDocumentation.getEndPoint(requestUri);
                this.appendOperationsToEndpoint(mappingInfo, handlerMethod, endPoint);
            }
        }
    }

    private ControllerDocumentation getApiDocumentation(MvcApiResource resource) {
        ControllerDocumentation emptyApiDocumentation;
        if (!this.apiCache.containsKey(resource.getControllerClass()) && (emptyApiDocumentation = resource.createEmptyApiDocumentation()) != null) {
            this.apiCache.put(resource.getControllerClass(), emptyApiDocumentation);
        }
        return this.apiCache.get(resource.getControllerClass());
    }

    private void appendOperationsToEndpoint(RequestMappingInfo mappingInfo, HandlerMethod handlerMethod, DocumentationEndPoint endPoint) {
        ApiMethodReader methodDoc = new ApiMethodReader(handlerMethod);
        for (RequestMethod requestMethod : mappingInfo.getMethodsCondition().getMethods()) {
            DocumentationOperation operation = methodDoc.getOperation(requestMethod);
            endPoint.addOperation(operation);
        }
    }

    public ControllerDocumentation getDocumentation(String apiName) {
        for (ControllerDocumentation documentation : this.apiCache.values()) {
            if (!documentation.matchesName(apiName).booleanValue()) continue;
            return documentation;
        }
        log.error("Could not find a matching resource for api with name '" + apiName + "'");
        return null;
    }

    public Map<String, HandlerMapping> getHandlerMappingBeans() {
        return this.handlerMappingBeans;
    }

    public Documentation getResourceListing() {
        return this.resourceListing;
    }
}

