/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger;

import com.google.common.collect.Maps;
import com.mangofactory.swagger.springmvc.MvcApiResource;
import com.wordnik.swagger.core.Api;
import com.wordnik.swagger.core.Documentation;
import com.wordnik.swagger.core.DocumentationEndPoint;
import com.wordnik.swagger.core.DocumentationOperation;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerDocumentation
extends Documentation {
    private static final Logger log = LoggerFactory.getLogger(ControllerDocumentation.class);
    private final MvcApiResource resource;
    private final Map<String, DocumentationEndPoint> endpointMap = Maps.newHashMap();

    public ControllerDocumentation(String apiVersion, String swaggerVersion, String basePath, MvcApiResource resource) {
        super(apiVersion, swaggerVersion, basePath, resource.getControllerUri());
        this.resource = resource;
    }

    private Class<?> getControllerClass() {
        return this.resource.getControllerClass();
    }

    public DocumentationEndPoint getEndPoint(String requestUri) {
        if (!this.endpointMap.containsKey(requestUri)) {
            DocumentationEndPoint endPoint = new DocumentationEndPoint(requestUri, this.getApiDescription());
            this.endpointMap.put(requestUri, endPoint);
            this.addApi(endPoint);
            log.debug("Added documentation endpoint for class {} at endpoint {}", (Object)this.getControllerClass().getName(), (Object)requestUri);
        }
        return this.endpointMap.get(requestUri);
    }

    private String getApiDescription() {
        Api apiAnnotation = this.getControllerClass().getAnnotation(Api.class);
        return apiAnnotation != null ? apiAnnotation.description() : "";
    }

    public Boolean matchesName(String name) {
        String nameWithForwardSlash = name.startsWith("/") ? name : "/" + name;
        String nameWithoutForwardSlash = name.startsWith("/") ? name.substring(1) : name;
        return this.getResourcePath().equals(nameWithoutForwardSlash) || this.getResourcePath().equals(nameWithForwardSlash);
    }

    public DocumentationOperation getEndPoint(String requestUri, RequestMethod method) {
        DocumentationEndPoint endPoint = this.getEndPoint(requestUri);
        if (endPoint == null || endPoint.getOperations() == null) {
            return null;
        }
        for (DocumentationOperation operation : endPoint.getOperations()) {
            if (!operation.getHttpMethod().equals(method.name())) continue;
            return operation;
        }
        return null;
    }
}

