/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.springmvc;

import com.google.common.collect.Lists;
import com.mangofactory.swagger.ApiError;
import com.mangofactory.swagger.ApiErrors;
import com.mangofactory.swagger.springmvc.AllowableRangesParser;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.core.DocumentationAllowableListValues;
import com.wordnik.swagger.core.DocumentationAllowableValues;
import com.wordnik.swagger.core.DocumentationError;
import com.wordnik.swagger.core.DocumentationOperation;
import com.wordnik.swagger.core.DocumentationParameter;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.method.HandlerMethod;

public class ApiMethodReader {
    private static final Logger log = LoggerFactory.getLogger(ApiMethodReader.class);
    private final HandlerMethod handlerMethod;
    private String summary;
    private String notes;
    private Class<?> responseClass;
    private String tags;
    private String nickname;
    private boolean deprecated;
    private final List<DocumentationError> errors = Lists.newArrayList();
    private final List<DocumentationParameter> parameters = Lists.newArrayList();

    public ApiMethodReader(HandlerMethod handlerMethod) {
        this.handlerMethod = handlerMethod;
        this.documentOperation();
        this.documentParameters();
        this.documentExceptions();
    }

    private void documentOperation() {
        ApiOperation apiOperation = (ApiOperation)this.handlerMethod.getMethodAnnotation(ApiOperation.class);
        if (apiOperation != null) {
            this.summary = apiOperation.value();
            this.notes = apiOperation.notes();
            this.tags = apiOperation.tags();
        }
        this.nickname = this.handlerMethod.getMethod().getName();
        this.deprecated = this.handlerMethod.getMethodAnnotation(Deprecated.class) != null;
        this.responseClass = this.handlerMethod.getReturnType().getParameterType();
    }

    public DocumentationOperation getOperation(RequestMethod requestMethod) {
        DocumentationOperation operation = new DocumentationOperation(requestMethod.name(), this.summary, this.notes);
        operation.setDeprecated(Boolean.valueOf(this.deprecated));
        operation.setNickname(this.nickname);
        for (DocumentationParameter parameter : this.parameters) {
            operation.addParameter(parameter);
        }
        this.setTags(operation);
        operation.setResponseClass(this.responseClass.getSimpleName());
        for (DocumentationError error : this.errors) {
            operation.addErrorResponse(error);
        }
        return operation;
    }

    private void setTags(DocumentationOperation operation) {
        if (this.tags != null) {
            operation.setTags(Arrays.asList(this.tags.split(",")));
        }
    }

    private void documentParameters() {
        for (MethodParameter methodParameter : this.handlerMethod.getMethodParameters()) {
            ApiParam apiParam = (ApiParam)methodParameter.getParameterAnnotation(ApiParam.class);
            if (apiParam == null) {
                log.warn("{} is missing @ApiParam annotation - so generating default documentation", (Object)methodParameter.getMethod());
                this.generateDefaultParameterDocumentation(methodParameter);
                continue;
            }
            String name = this.selectBestParameterName(methodParameter);
            DocumentationAllowableValues allowableValues = this.convertToAllowableValues(apiParam.allowableValues());
            String description = apiParam.value();
            if (StringUtils.isEmpty((String)name)) {
                name = methodParameter.getParameterName();
            }
            String paramType = this.getParameterType(methodParameter);
            String dataType = methodParameter.getParameterType().getSimpleName();
            RequestParam requestParam = (RequestParam)methodParameter.getParameterAnnotation(RequestParam.class);
            boolean isRequired = apiParam.required();
            if (requestParam != null) {
                isRequired = requestParam.required();
            }
            DocumentationParameter documentationParameter = new DocumentationParameter(name, description, apiParam.internalDescription(), paramType, apiParam.defaultValue(), allowableValues, isRequired, apiParam.allowMultiple());
            documentationParameter.setDataType(dataType);
            this.parameters.add(documentationParameter);
        }
    }

    private String getParameterType(MethodParameter methodParameter) {
        RequestParam requestParam = (RequestParam)methodParameter.getParameterAnnotation(RequestParam.class);
        if (requestParam != null) {
            return "query";
        }
        PathVariable pathVariable = (PathVariable)methodParameter.getParameterAnnotation(PathVariable.class);
        if (pathVariable != null) {
            return "path";
        }
        RequestBody requestBody = (RequestBody)methodParameter.getParameterAnnotation(RequestBody.class);
        if (requestBody != null) {
            return "body";
        }
        ModelAttribute modelAttribute = (ModelAttribute)methodParameter.getParameterAnnotation(ModelAttribute.class);
        if (modelAttribute != null) {
            return "body";
        }
        return "query";
    }

    private String selectBestParameterName(MethodParameter methodParameter) {
        ApiParam apiParam = (ApiParam)methodParameter.getParameterAnnotation(ApiParam.class);
        if (apiParam != null && !StringUtils.isEmpty((String)apiParam.name())) {
            return apiParam.name();
        }
        PathVariable pathVariable = (PathVariable)methodParameter.getParameterAnnotation(PathVariable.class);
        if (pathVariable != null && !StringUtils.isEmpty((String)pathVariable.value())) {
            return pathVariable.value();
        }
        ModelAttribute modelAttribute = (ModelAttribute)methodParameter.getParameterAnnotation(ModelAttribute.class);
        if (modelAttribute != null && !StringUtils.isEmpty((String)modelAttribute.value())) {
            return modelAttribute.value();
        }
        RequestParam requestParam = (RequestParam)methodParameter.getParameterAnnotation(RequestParam.class);
        if (requestParam != null && !StringUtils.isEmpty((String)requestParam.value())) {
            return requestParam.value();
        }
        return methodParameter.getParameterName();
    }

    private void generateDefaultParameterDocumentation(MethodParameter methodParameter) {
        String name = this.selectBestParameterName(methodParameter);
        String dataType = methodParameter.getParameterType().getSimpleName();
        String paramType = this.getParameterType(methodParameter);
        boolean isRequired = false;
        RequestParam requestParam = (RequestParam)methodParameter.getParameterAnnotation(RequestParam.class);
        if (requestParam != null) {
            isRequired = requestParam.required();
        }
        DocumentationParameter documentationParameter = new DocumentationParameter(name, "", "", paramType, "", null, isRequired, false);
        documentationParameter.setDataType(dataType);
        this.parameters.add(documentationParameter);
    }

    protected DocumentationAllowableValues convertToAllowableValues(String csvString) {
        if (csvString.toLowerCase().startsWith("range[")) {
            String[] ranges = csvString.substring(6, csvString.length() - 1).split(",");
            return AllowableRangesParser.buildAllowableRangeValues(ranges, csvString);
        }
        if (csvString.toLowerCase().startsWith("rangeexclusive[")) {
            String[] ranges = csvString.substring(15, csvString.length() - 1).split(",");
            return AllowableRangesParser.buildAllowableRangeValues(ranges, csvString);
        }
        if (csvString == null || csvString.length() == 0) {
            return null;
        }
        List<String> params = Arrays.asList(csvString.split(","));
        return new DocumentationAllowableListValues(params);
    }

    private void documentExceptions() {
        this.discoverSwaggerAnnotatedExceptions();
        this.discoverSpringMvcExceptions();
        this.discoverThrowsExceptions();
    }

    private void discoverThrowsExceptions() {
        Class<?>[] exceptionTypes;
        for (Class<?> exceptionType : exceptionTypes = this.handlerMethod.getMethod().getExceptionTypes()) {
            this.appendErrorFromClass(exceptionType);
        }
    }

    private void discoverSpringMvcExceptions() {
        ApiErrors apiErrors = (ApiErrors)this.handlerMethod.getMethodAnnotation(ApiErrors.class);
        if (apiErrors == null) {
            return;
        }
        for (Class<? extends Throwable> exceptionClass : apiErrors.value()) {
            this.appendErrorFromClass(exceptionClass);
        }
    }

    void appendErrorFromClass(Class<? extends Throwable> exceptionClass) {
        ApiError apiError = exceptionClass.getAnnotation(ApiError.class);
        if (apiError == null) {
            return;
        }
        this.errors.add(new DocumentationError(apiError.code(), apiError.reason()));
    }

    private void discoverSwaggerAnnotatedExceptions() {
        com.wordnik.swagger.annotations.ApiErrors apiErrors = (com.wordnik.swagger.annotations.ApiErrors)this.handlerMethod.getMethodAnnotation(com.wordnik.swagger.annotations.ApiErrors.class);
        if (apiErrors == null) {
            return;
        }
        for (com.wordnik.swagger.annotations.ApiError apiError : apiErrors.value()) {
            this.errors.add(new DocumentationError(apiError.code(), apiError.reason()));
        }
    }

    public String getSummary() {
        return this.summary;
    }

    public String getNotes() {
        return this.notes;
    }

    public Class<?> getResponseClass() {
        return this.responseClass;
    }

    public String getTags() {
        return this.tags;
    }

    public List<DocumentationError> getErrors() {
        return this.errors;
    }
}

