/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger;

import com.google.common.collect.Lists;
import com.mangofactory.swagger.SwaggerConfigurationExtension;
import com.mangofactory.swagger.filters.AnnotatedEndpointFilter;
import com.mangofactory.swagger.filters.AnnotatedErrorsFilter;
import com.mangofactory.swagger.filters.AnnotatedOperationFilter;
import com.mangofactory.swagger.filters.AnnotatedParameterFilter;
import com.mangofactory.swagger.filters.Filter;
import com.mangofactory.swagger.filters.FilterContext;
import com.mangofactory.swagger.filters.Filters;
import com.mangofactory.swagger.spring.filters.ApplicationFilter;
import com.mangofactory.swagger.spring.filters.EndPointFilter;
import com.mangofactory.swagger.spring.filters.ErrorsFilter;
import com.mangofactory.swagger.spring.filters.OperationFilter;
import com.mangofactory.swagger.spring.filters.ParameterFilter;
import com.wordnik.swagger.core.Documentation;
import com.wordnik.swagger.core.DocumentationEndPoint;
import com.wordnik.swagger.core.DocumentationError;
import com.wordnik.swagger.core.DocumentationOperation;
import com.wordnik.swagger.core.DocumentationParameter;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.WebApplicationContext;

public class SwaggerConfiguration
implements InitializingBean {
    public static final String API_DOCS_PATH = "/api-docs";
    public static final String SWAGGER_VERSION = "1.0";
    private final String documentationBasePath;
    private final String swaggerVersion;
    private SwaggerConfigurationExtension extensions;
    private String apiVersion;
    private String basePath;
    private List<String> excludedResources;
    private final List<Filter<Documentation>> documentationFilters = Lists.newArrayList();
    private final List<Filter<DocumentationEndPoint>> endpointFilters = Lists.newArrayList();
    private final List<Filter<DocumentationOperation>> operationFilters = Lists.newArrayList();
    private final List<Filter<DocumentationParameter>> parameterFilters = Lists.newArrayList();
    private final List<Filter<List<DocumentationError>>> errorFilters = Lists.newArrayList();
    private final List<Class<?>> ignorableParameterTypes = Lists.newArrayList();

    public SwaggerConfiguration(boolean applyDefaults) {
        this.swaggerVersion = SWAGGER_VERSION;
        this.documentationBasePath = API_DOCS_PATH;
        this.excludedResources = Lists.newArrayList();
        this.ignorableParameterTypes.addAll(Lists.newArrayList((Object[])new Class[]{ModelMap.class, ServletContext.class, HttpServletRequest.class, HttpServletResponse.class, HashMap.class}));
        if (applyDefaults) {
            this.applyDefaults();
        }
    }

    public SwaggerConfiguration() {
        this(true);
    }

    private void applyDefaults() {
        ApplicationFilter applicationDocumentationFilter = new ApplicationFilter();
        this.documentationFilters.add(applicationDocumentationFilter);
        EndPointFilter endPointFilter = new EndPointFilter();
        AnnotatedEndpointFilter annotationEndpointFilter = new AnnotatedEndpointFilter();
        this.endpointFilters.addAll(Lists.newArrayList((Object[])new Filter[]{endPointFilter, annotationEndpointFilter}));
        OperationFilter operationFilter = new OperationFilter();
        AnnotatedOperationFilter annotatedOperationFilter = new AnnotatedOperationFilter();
        this.operationFilters.addAll(Lists.newArrayList((Object[])new Filter[]{operationFilter, annotatedOperationFilter}));
        ParameterFilter parameterFilter = new ParameterFilter();
        AnnotatedParameterFilter annotatedParameterFilter = new AnnotatedParameterFilter();
        this.parameterFilters.addAll(Lists.newArrayList((Object[])new Filter[]{parameterFilter, annotatedParameterFilter}));
        ErrorsFilter errorFilter = new ErrorsFilter();
        AnnotatedErrorsFilter annotatedErrorFilter = new AnnotatedErrorsFilter();
        this.errorFilters.addAll(Lists.newArrayList((Object[])new Filter[]{errorFilter, annotatedErrorFilter}));
    }

    public Documentation newDocumentation(WebApplicationContext webApplicationContext) {
        FilterContext<Documentation> context = new FilterContext<Documentation>(new Documentation(null, this.swaggerVersion, this.basePath, null));
        context.put("swagger", this);
        context.put("webApplicationContext", webApplicationContext);
        Filters.Fn.applyFilters(this.documentationFilters, context);
        return context.subject();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.extensions != null) {
            this.documentationFilters.addAll(this.extensions.getDocumentationFilters());
            this.endpointFilters.addAll(this.extensions.getEndpointFilters());
            this.operationFilters.addAll(this.extensions.getOperationFilters());
            this.parameterFilters.addAll(this.extensions.getParameterFilters());
            this.errorFilters.addAll(this.extensions.getErrorFilters());
            this.ignorableParameterTypes.addAll(this.extensions.getIgnorableParameterTypes());
        }
    }

    public boolean isExcluded(String controllerUri) {
        return this.excludedResources.contains(controllerUri);
    }

    public boolean isParameterTypeIgnoreable(Class<?> parameterType) {
        return this.ignorableParameterTypes.contains(parameterType);
    }

    public String getDocumentationBasePath() {
        return this.documentationBasePath;
    }

    public String getSwaggerVersion() {
        return this.swaggerVersion;
    }

    public SwaggerConfigurationExtension getExtensions() {
        return this.extensions;
    }

    public void setExtensions(SwaggerConfigurationExtension extensions) {
        this.extensions = extensions;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setExcludedResources(List<String> excludedResources) {
        this.excludedResources = excludedResources;
    }

    public List<Filter<Documentation>> getDocumentationFilters() {
        return this.documentationFilters;
    }

    public List<Filter<DocumentationEndPoint>> getEndpointFilters() {
        return this.endpointFilters;
    }

    public List<Filter<DocumentationOperation>> getOperationFilters() {
        return this.operationFilters;
    }

    public List<Filter<DocumentationParameter>> getParameterFilters() {
        return this.parameterFilters;
    }

    public List<Filter<List<DocumentationError>>> getErrorFilters() {
        return this.errorFilters;
    }

    public List<Class<?>> getIgnorableParameterTypes() {
        return this.ignorableParameterTypes;
    }
}

