/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.spring;

import com.mangofactory.swagger.SwaggerConfiguration;
import com.mangofactory.swagger.spring.UriBuilder;
import com.mangofactory.swagger.spring.controller.DocumentationController;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.core.Documentation;
import com.wordnik.swagger.core.DocumentationEndPoint;
import java.lang.reflect.AnnotatedElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;

public class ControllerAdapter {
    private static final Logger log = LoggerFactory.getLogger(ControllerAdapter.class);
    private final HandlerMethod handlerMethod;
    private final Class<?> controllerClass;
    private final SwaggerConfiguration configuration;
    private Documentation parent;

    public ControllerAdapter(Documentation parent, HandlerMethod handlerMethod, SwaggerConfiguration configuration) {
        this.parent = parent;
        this.handlerMethod = handlerMethod;
        this.configuration = configuration;
        this.controllerClass = ClassUtils.getUserClass((Class)this.handlerMethod.getBeanType());
    }

    public DocumentationEndPoint describeAsDocumentationEndpoint() {
        String documentationUri = new UriBuilder(this.configuration.getDocumentationBasePath()).appendPath(this.getListingPath()).toString();
        return new DocumentationEndPoint(documentationUri, this.getApiDescription());
    }

    private String getListingPath() {
        Api apiAnnotation = this.controllerClass.getAnnotation(Api.class);
        if (apiAnnotation == null || apiAnnotation.listingPath().equals("")) {
            return this.getControllerUri();
        }
        return apiAnnotation.listingPath();
    }

    private String getApiDescription() {
        Api apiAnnotation = this.controllerClass.getAnnotation(Api.class);
        if (apiAnnotation == null) {
            return null;
        }
        return apiAnnotation.description();
    }

    public String getControllerUri() {
        String requestUri = this.resolveRequestUri(this.controllerClass);
        if (requestUri == null) {
            log.info("Class {} has handler methods, but no class-level @RequestMapping. Continue with method-level {}", (Object)this.controllerClass.getName(), (Object)this.handlerMethod.getMethod().getName());
            requestUri = this.resolveRequestUri(this.handlerMethod.getMethod());
            if (requestUri == null) {
                log.warn("Unable to resolve the uri for class {} and method {}. No documentation will be generated", (Object)this.controllerClass.getName(), (Object)this.handlerMethod.getMethod().getName());
                return null;
            }
        }
        return requestUri;
    }

    protected String resolveRequestUri(AnnotatedElement annotatedElement) {
        RequestMapping requestMapping = annotatedElement.getAnnotation(RequestMapping.class);
        if (requestMapping == null) {
            log.info("Class {} has no @RequestMapping", (Object)annotatedElement);
            return null;
        }
        String[] requestUris = requestMapping.value();
        if (requestUris == null || requestUris.length == 0) {
            log.info("Class {} contains a @RequestMapping, but could not resolve the uri", (Object)annotatedElement);
            return null;
        }
        if (requestUris.length > 1) {
            log.info("Class {} contains a @RequestMapping with multiple uri's. Only the first one will be documented.", (Object)annotatedElement);
        }
        return requestUris[0];
    }

    public String toString() {
        return "ApiResource for " + this.controllerClass.getSimpleName() + " at " + this.getControllerUri();
    }

    public Class<?> getControllerClass() {
        return this.controllerClass;
    }

    public boolean isInternalResource() {
        return this.controllerClass == DocumentationController.class;
    }

    public Documentation documentation() {
        return this.parent;
    }

    public HandlerMethod getHandlerMethod() {
        return this.handlerMethod;
    }
}

