/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.spring.filters;

import com.mangofactory.swagger.filters.Filter;
import com.mangofactory.swagger.filters.FilterContext;
import com.mangofactory.swagger.spring.Descriptions;
import com.mangofactory.swagger.spring.UriBuilder;
import com.wordnik.swagger.core.DocumentationEndPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;

public class EndPointFilter
implements Filter<DocumentationEndPoint> {
    private static final Logger log = LoggerFactory.getLogger(EndPointFilter.class);

    @Override
    public void apply(FilterContext<DocumentationEndPoint> context) {
        DocumentationEndPoint doc = context.subject();
        Class controllerClass = (Class)context.get("controllerClass");
        HandlerMethod handlerMethod = (HandlerMethod)context.get("handlerMethod");
        String documentationUri = new UriBuilder(this.maybeGetUriFromRequestMappingAnnotation(controllerClass)).appendPath(this.maybeGetUriFromRequestMappingAnnotation(handlerMethod)).toString();
        doc.setPath(documentationUri);
        doc.setDescription(this.getDescription(controllerClass));
    }

    private String getDescription(Class<?> controllerClass) {
        return Descriptions.splitCamelCase(controllerClass.getSimpleName());
    }

    public String maybeGetUriFromRequestMappingAnnotation(Class<?> controllerClass) {
        RequestMapping requestMapping = controllerClass.getAnnotation(RequestMapping.class);
        String requestUri = this.resolveRequestUri(requestMapping);
        if (requestUri == null) {
            return "";
        }
        return requestUri;
    }

    public String maybeGetUriFromRequestMappingAnnotation(HandlerMethod handlerMethod) {
        String requestUri = this.resolveRequestUri((RequestMapping)handlerMethod.getMethodAnnotation(RequestMapping.class));
        if (requestUri == null) {
            return "";
        }
        return requestUri;
    }

    private String resolveRequestUri(RequestMapping requestMapping) {
        if (requestMapping == null) {
            log.info("Class {} has no @RequestMapping", (Object)requestMapping);
            return null;
        }
        String[] requestUris = requestMapping.value();
        if (requestUris == null || requestUris.length == 0) {
            log.info("Class {} contains a @RequestMapping, but could not resolve the uri", (Object)requestMapping);
            return null;
        }
        if (requestUris.length > 1) {
            log.info("Class {} contains a @RequestMapping with multiple uri's. Only the first one will be documented.", (Object)requestMapping);
        }
        return requestUris[0];
    }
}

