/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.spring.filters;

import com.mangofactory.swagger.filters.Filter;
import com.mangofactory.swagger.filters.FilterContext;
import com.mangofactory.swagger.spring.Descriptions;
import com.wordnik.swagger.core.DocumentationOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;

public class OperationFilter
implements Filter<DocumentationOperation> {
    private static final Logger log = LoggerFactory.getLogger(OperationFilter.class);

    @Override
    public void apply(FilterContext<DocumentationOperation> context) {
        DocumentationOperation operation = context.subject();
        HandlerMethod handlerMethod = (HandlerMethod)context.get("handlerMethod");
        this.documentOperation(operation, handlerMethod);
    }

    private void documentOperation(DocumentationOperation operation, HandlerMethod handlerMethod) {
        operation.setSummary(Descriptions.splitCamelCase(handlerMethod.getMethod().getName()));
        operation.setNotes("");
        operation.setNickname(handlerMethod.getMethod().getName());
        operation.setDeprecated(Boolean.valueOf(handlerMethod.getMethodAnnotation(Deprecated.class) != null));
        operation.setResponseClass(handlerMethod.getReturnType().getParameterType().getSimpleName());
    }
}

