/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.spring;

import com.mangofactory.swagger.SwaggerConfiguration;
import com.mangofactory.swagger.spring.UriBuilder;
import com.mangofactory.swagger.spring.UriExtractor;
import com.mangofactory.swagger.spring.controller.DocumentationController;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.core.Documentation;
import com.wordnik.swagger.core.DocumentationEndPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;
import org.springframework.web.method.HandlerMethod;

public class ControllerAdapter {
    private static final Logger log = LoggerFactory.getLogger(ControllerAdapter.class);
    private final HandlerMethod handlerMethod;
    private final Class<?> controllerClass;
    private final SwaggerConfiguration configuration;
    private Documentation parent;

    public ControllerAdapter(Documentation parent, HandlerMethod handlerMethod, SwaggerConfiguration configuration) {
        this.parent = parent;
        this.handlerMethod = handlerMethod;
        this.configuration = configuration;
        this.controllerClass = ClassUtils.getUserClass((Class)this.handlerMethod.getBeanType());
    }

    public DocumentationEndPoint describeAsDocumentationEndpoint() {
        String documentationUri = new UriBuilder(this.configuration.getDocumentationBasePath()).appendPath(this.getListingPath()).toString();
        return new DocumentationEndPoint(documentationUri, this.getApiDescription(this.controllerClass));
    }

    private String getListingPath() {
        Api apiAnnotation = this.controllerClass.getAnnotation(Api.class);
        if (apiAnnotation == null || apiAnnotation.listingPath().equals("")) {
            return UriExtractor.getDocumentationEndpointUri(this.controllerClass);
        }
        return apiAnnotation.listingPath();
    }

    private String getApiDescription(Class<?> controllerClass) {
        Api apiAnnotation = controllerClass.getAnnotation(Api.class);
        if (apiAnnotation == null) {
            return null;
        }
        return apiAnnotation.description();
    }

    public String toString() {
        return String.format("ApiResource for %s at %s", this.controllerClass.getSimpleName(), UriExtractor.getMethodLevelUri(this.controllerClass, this.handlerMethod));
    }

    public Class<?> getControllerClass() {
        return this.controllerClass;
    }

    public boolean isInternalResource() {
        return this.controllerClass == DocumentationController.class;
    }

    public Documentation documentation() {
        return this.parent;
    }

    public HandlerMethod getHandlerMethod() {
        return this.handlerMethod;
    }
}

