/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.spring.controller;

import com.mangofactory.swagger.ControllerDocumentation;
import com.mangofactory.swagger.SwaggerConfiguration;
import com.mangofactory.swagger.spring.DocumentationReader;
import com.wordnik.swagger.core.Documentation;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Controller
@RequestMapping(value={"/api-docs"})
public class DocumentationController
implements ServletContextAware {
    public static final String CONTROLLER_ENDPOINT = "api-docs";
    @Autowired
    private SwaggerConfiguration swaggerConfiguration;
    @Autowired
    private RequestMappingHandlerMapping handlerMapping;
    private DocumentationReader apiReader;

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Documentation getResourceListing() {
        return this.apiReader.getDocumentation();
    }

    @RequestMapping(value={"/**"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ControllerDocumentation getApiDocumentation(HttpServletRequest request) {
        String fullUrl = String.valueOf(request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE));
        int indexOfApiName = fullUrl.indexOf("/", 1) + 1;
        return this.apiReader.getDocumentation(fullUrl.substring(indexOfApiName));
    }

    public void setServletContext(ServletContext servletContext) {
        this.apiReader = new DocumentationReader(this.swaggerConfiguration, WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext), this.handlerMapping);
    }

    public SwaggerConfiguration getSwaggerConfiguration() {
        return this.swaggerConfiguration;
    }

    public void setSwaggerConfiguration(SwaggerConfiguration swaggerConfiguration) {
        this.swaggerConfiguration = swaggerConfiguration;
    }

    public DocumentationReader getApiReader() {
        return this.apiReader;
    }
}

