/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.google.common.base.Function;
import com.mangofactory.swagger.Model;
import com.wordnik.swagger.core.DocumentationSchema;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

class Models {
    Models() {
    }

    public static class Fn {
        private Fn() {
            throw new UnsupportedOperationException();
        }

        public static Function<Model, DocumentationSchema> modelToSchema() {
            return new Function<Model, DocumentationSchema>(){

                public DocumentationSchema apply(Model input) {
                    ObjectMapper mapper = new ObjectMapper();
                    mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                    DocumentationSchema schema = new DocumentationSchema();
                    schema.setId(input.getName());
                    try {
                        JsonSchema jsonSchema = mapper.generateJsonSchema(input.getType());
                        ObjectWriter writer = mapper.writer();
                        StringWriter stringWriter = new StringWriter();
                        writer.writeValue((Writer)stringWriter, (Object)jsonSchema);
                        String schemaAsString = ((Object)stringWriter).toString();
                        schema.setItems((DocumentationSchema)mapper.readValue(schemaAsString, DocumentationSchema.class));
                        return Fn.fixup(schema);
                    }
                    catch (IOException e) {
                        return schema;
                    }
                }
            };
        }

        private static DocumentationSchema fixup(DocumentationSchema schema) {
            DocumentationSchema fixup = new DocumentationSchema();
            fixup.setId(schema.getId());
            fixup.setProperties(schema.getItems().getProperties());
            return fixup;
        }
    }
}

