/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.spring.filters;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mangofactory.swagger.ControllerDocumentation;
import com.mangofactory.swagger.Model;
import com.mangofactory.swagger.filters.Filter;
import com.mangofactory.swagger.filters.FilterContext;
import com.mangofactory.swagger.spring.Descriptions;
import com.wordnik.swagger.core.DocumentationAllowableListValues;
import com.wordnik.swagger.core.DocumentationAllowableValues;
import com.wordnik.swagger.core.DocumentationParameter;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public class ParameterFilter
implements Filter<DocumentationParameter> {
    @Override
    public void apply(FilterContext<DocumentationParameter> context) {
        DocumentationParameter parameter = context.subject();
        MethodParameter methodParameter = (MethodParameter)context.get("methodParameter");
        Class parameterType = (Class)context.get("parameterType");
        String defaultParameterName = (String)context.get("defaultParameterName");
        ControllerDocumentation controllerDocumentation = (ControllerDocumentation)((Object)context.get("controllerDocumentation"));
        this.documentParameter(controllerDocumentation, parameter, methodParameter, parameterType, defaultParameterName);
    }

    private void documentParameter(ControllerDocumentation controllerDocumentation, DocumentationParameter parameter, MethodParameter methodParameter, Class parameterType, String defaultParameterName) {
        String name = this.selectBestParameterName(methodParameter, defaultParameterName);
        String description = Descriptions.splitCamelCase(name);
        if (StringUtils.isEmpty((String)name)) {
            name = methodParameter.getParameterName();
        }
        String paramType = this.getParameterType(methodParameter);
        String dataType = parameterType.getSimpleName();
        parameter.setDataType(dataType);
        this.maybeAddParameterTypeToModels(controllerDocumentation, parameterType, dataType);
        RequestParam requestParam = (RequestParam)methodParameter.getParameterAnnotation(RequestParam.class);
        boolean isRequired = false;
        if (requestParam != null) {
            isRequired = requestParam.required();
        }
        parameter.setName(name);
        parameter.setDescription(description);
        parameter.setNotes("");
        parameter.setParamType(paramType);
        parameter.setDefaultValue("");
        parameter.setAllowableValues(this.maybeGetAllowableValues(parameterType));
        parameter.setRequired(isRequired);
        parameter.setAllowMultiple(false);
        parameter.setDataType(dataType);
    }

    private DocumentationAllowableValues maybeGetAllowableValues(Class<?> parameterType) {
        DocumentationAllowableListValues allowableValues = null;
        if (parameterType.isEnum()) {
            allowableValues = new DocumentationAllowableListValues(Lists.transform((List)Lists.newArrayList((Object[])parameterType.getEnumConstants()), this.convertToString()));
        }
        return allowableValues;
    }

    private Function<? super Object, String> convertToString() {
        return new Function<Object, String>(){

            public String apply(Object input) {
                return input.toString();
            }
        };
    }

    private void maybeAddParameterTypeToModels(ControllerDocumentation controllerDocumentation, Class<?> parameterType, String dataType) {
        if (this.isKnownType(parameterType)) {
            return;
        }
        if (parameterType.isArray()) {
            String componentType = parameterType.getComponentType().getSimpleName();
            if (this.isComplexType(parameterType.getComponentType())) {
                controllerDocumentation.putModel(componentType, new Model(String.format("Array[%s]", componentType), parameterType.getComponentType()));
            }
        } else {
            controllerDocumentation.putModel(dataType, new Model(dataType, parameterType));
        }
    }

    private boolean isKnownType(Class<?> parameterType) {
        return parameterType.isAssignableFrom(List.class) || parameterType.isAssignableFrom(Set.class) || parameterType.isPrimitive() || parameterType.isEnum() || parameterType.isAssignableFrom(String.class) || parameterType.isAssignableFrom(Date.class);
    }

    private boolean isComplexType(Class<?> parameterType) {
        return !parameterType.isEnum() && !parameterType.isPrimitive() && !parameterType.isArray() && !parameterType.isAssignableFrom(List.class) && !parameterType.isAssignableFrom(Set.class) && !parameterType.isAssignableFrom(String.class) && !parameterType.isAssignableFrom(Date.class);
    }

    private String getParameterType(MethodParameter methodParameter) {
        RequestParam requestParam = (RequestParam)methodParameter.getParameterAnnotation(RequestParam.class);
        if (requestParam != null) {
            return "query";
        }
        PathVariable pathVariable = (PathVariable)methodParameter.getParameterAnnotation(PathVariable.class);
        if (pathVariable != null) {
            return "path";
        }
        RequestBody requestBody = (RequestBody)methodParameter.getParameterAnnotation(RequestBody.class);
        if (requestBody != null) {
            return "body";
        }
        ModelAttribute modelAttribute = (ModelAttribute)methodParameter.getParameterAnnotation(ModelAttribute.class);
        if (modelAttribute != null) {
            return "body";
        }
        return "query";
    }

    private String selectBestParameterName(MethodParameter methodParameter, String defaultParameterName) {
        PathVariable pathVariable = (PathVariable)methodParameter.getParameterAnnotation(PathVariable.class);
        if (pathVariable != null && !StringUtils.isEmpty((String)pathVariable.value())) {
            return pathVariable.value();
        }
        ModelAttribute modelAttribute = (ModelAttribute)methodParameter.getParameterAnnotation(ModelAttribute.class);
        if (modelAttribute != null && !StringUtils.isEmpty((String)modelAttribute.value())) {
            return modelAttribute.value();
        }
        RequestParam requestParam = (RequestParam)methodParameter.getParameterAnnotation(RequestParam.class);
        if (requestParam != null && !StringUtils.isEmpty((String)requestParam.value())) {
            return requestParam.value();
        }
        if (!Strings.isNullOrEmpty((String)defaultParameterName)) {
            return defaultParameterName;
        }
        if (Strings.isNullOrEmpty((String)methodParameter.getParameterName())) {
            return String.format("param%s", methodParameter.getParameterIndex());
        }
        return methodParameter.getParameterName();
    }
}

