/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger;

import com.google.common.base.Function;
import com.mangofactory.swagger.ControllerDocumentation;
import com.mangofactory.swagger.Model;
import com.wordnik.swagger.core.DocumentationSchema;
import com.wordnik.swagger.jsonschema.SwaggerJsonSchemaProvider;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Models {
    private static final Logger log = LoggerFactory.getLogger(Models.class);

    public static void maybeAddParameterTypeToModels(ControllerDocumentation controllerDocumentation, Class<?> parameterType, String dataType) {
        if (Models.isKnownType(parameterType)) {
            return;
        }
        if (parameterType.isArray()) {
            String componentType = parameterType.getComponentType().getSimpleName();
            if (Models.isComplexType(parameterType.getComponentType())) {
                controllerDocumentation.putModel(componentType, new Model(String.format("Array[%s]", componentType), parameterType.getComponentType()));
            }
        } else {
            controllerDocumentation.putModel(dataType, new Model(dataType, parameterType));
        }
    }

    private static boolean isKnownType(Class<?> parameterType) {
        return parameterType.isAssignableFrom(List.class) || parameterType.isAssignableFrom(Set.class) || parameterType.isPrimitive() || parameterType.isEnum() || parameterType.isAssignableFrom(String.class) || parameterType.isAssignableFrom(Date.class);
    }

    private static boolean isComplexType(Class<?> parameterType) {
        return !parameterType.isEnum() && !parameterType.isPrimitive() && !parameterType.isArray() && !parameterType.isAssignableFrom(List.class) && !parameterType.isAssignableFrom(Set.class) && !parameterType.isAssignableFrom(String.class) && !parameterType.isAssignableFrom(Date.class);
    }

    public static class Fn {
        private Fn() {
            throw new UnsupportedOperationException();
        }

        public static Function<Model, DocumentationSchema> modelToSchema() {
            return new Function<Model, DocumentationSchema>(){

                public DocumentationSchema apply(Model input) {
                    SwaggerJsonSchemaProvider provider = new SwaggerJsonSchemaProvider();
                    return provider.read(input.getType()).toDocumentationSchema();
                }
            };
        }

        private static DocumentationSchema fixup(DocumentationSchema schema) {
            DocumentationSchema fixup = new DocumentationSchema();
            fixup.setId(schema.getId());
            fixup.setProperties(schema.getItems().getProperties());
            return fixup;
        }
    }
}

