/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.filters;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.mangofactory.swagger.ControllerDocumentation;
import com.mangofactory.swagger.Model;
import com.mangofactory.swagger.annotations.Annotations;
import com.mangofactory.swagger.annotations.ApiModel;
import com.mangofactory.swagger.filters.Filter;
import com.mangofactory.swagger.filters.FilterContext;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.core.DocumentationOperation;
import java.util.List;
import org.springframework.web.method.HandlerMethod;

public class AnnotatedOperationFilter
implements Filter<DocumentationOperation> {
    @Override
    public void apply(FilterContext<DocumentationOperation> context) {
        DocumentationOperation operation = context.subject();
        HandlerMethod handlerMethod = (HandlerMethod)context.get("handlerMethod");
        ControllerDocumentation controllerDocumentation = (ControllerDocumentation)((Object)context.get("controllerDocumentation"));
        this.documentOperation(controllerDocumentation, operation, handlerMethod);
    }

    private void documentOperation(ControllerDocumentation controllerDocumentation, DocumentationOperation operation, HandlerMethod handlerMethod) {
        ApiModel apiModel;
        ApiOperation apiOperation = (ApiOperation)handlerMethod.getMethodAnnotation(ApiOperation.class);
        if (apiOperation != null) {
            operation.setSummary(apiOperation.value());
            operation.setNotes(apiOperation.notes());
            operation.setResponseClass(apiOperation.responseClass());
            operation.setTags((List)Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().split((CharSequence)apiOperation.tags())));
        }
        if ((apiModel = (ApiModel)handlerMethod.getMethodAnnotation(ApiModel.class)) != null) {
            operation.setResponseClass(Annotations.getAnnotatedType(apiModel));
            String simpleName = apiModel.type().getSimpleName();
            controllerDocumentation.putModel(simpleName, new Model(simpleName, apiModel.type()));
        }
    }
}

