/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.spring;

import com.google.common.base.Strings;
import com.mangofactory.swagger.spring.Descriptions;
import com.mangofactory.swagger.spring.UriBuilder;
import java.lang.reflect.AnnotatedElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;

public class UriExtractor {
    private static final Logger log = LoggerFactory.getLogger(UriExtractor.class);

    public static String getDocumentationEndpointUri(Class<?> controllerClass) {
        String classLevelUri = UriExtractor.resolveRequestUri(UriExtractor.requestMapping(controllerClass));
        String defaultUri = Descriptions.splitCamelCase(controllerClass.getSimpleName(), "-").toLowerCase();
        if (Strings.isNullOrEmpty((String)classLevelUri)) {
            classLevelUri = "/" + defaultUri;
        }
        if (!classLevelUri.startsWith("/")) {
            classLevelUri = String.format("/%s", classLevelUri);
        }
        UriBuilder builder = new UriBuilder();
        UriExtractor.maybeAppendPath(builder, classLevelUri);
        return builder.toString();
    }

    public static String getMethodLevelUri(Class<?> controllerClass, HandlerMethod handlerMethod) {
        String classLevelUri = UriExtractor.resolveRequestUri(UriExtractor.requestMapping(controllerClass));
        if (Strings.isNullOrEmpty((String)classLevelUri)) {
            classLevelUri = "/";
        }
        if (!classLevelUri.startsWith("/")) {
            classLevelUri = String.format("/%s", classLevelUri);
        }
        String methodLevelUri = UriExtractor.resolveRequestUri(UriExtractor.requestMapping(handlerMethod.getMethod()));
        UriBuilder builder = new UriBuilder();
        UriExtractor.maybeAppendPath(builder, classLevelUri);
        UriExtractor.maybeAppendPath(builder, methodLevelUri);
        return builder.toString();
    }

    private static void maybeAppendPath(UriBuilder builder, String toAppendUri) {
        if (!Strings.isNullOrEmpty((String)toAppendUri)) {
            builder.appendPath(toAppendUri);
        }
    }

    private static RequestMapping requestMapping(AnnotatedElement annotated) {
        return annotated.getAnnotation(RequestMapping.class);
    }

    protected static String resolveRequestUri(RequestMapping requestMapping) {
        if (requestMapping == null) {
            log.info("Class {} has no @RequestMapping", (Object)requestMapping);
            return null;
        }
        String[] requestUris = requestMapping.value();
        if (requestUris == null || requestUris.length == 0) {
            log.info("Class {} contains a @RequestMapping, but could not resolve the uri", (Object)requestMapping);
            return null;
        }
        if (requestUris.length > 1) {
            log.info("Class {} contains a @RequestMapping with multiple uri's. Only the first one will be documented.", (Object)requestMapping);
        }
        return requestUris[0];
    }
}

