/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.spring.filters;

import com.mangofactory.swagger.filters.Filter;
import com.mangofactory.swagger.filters.FilterContext;
import com.mangofactory.swagger.spring.Descriptions;
import com.mangofactory.swagger.spring.UriExtractor;
import com.wordnik.swagger.core.DocumentationEndPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;

public class EndPointFilter
implements Filter<DocumentationEndPoint> {
    private static final Logger log = LoggerFactory.getLogger(EndPointFilter.class);

    @Override
    public void apply(FilterContext<DocumentationEndPoint> context) {
        DocumentationEndPoint doc = context.subject();
        Class controllerClass = (Class)context.get("controllerClass");
        HandlerMethod handlerMethod = (HandlerMethod)context.get("handlerMethod");
        String documentationUri = UriExtractor.getMethodLevelUri(controllerClass, handlerMethod);
        doc.setPath(documentationUri);
        doc.setDescription(this.getDescription(controllerClass));
    }

    private String getDescription(Class<?> controllerClass) {
        return Descriptions.splitCamelCase(controllerClass.getSimpleName());
    }
}

