/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.google.common.base.Function;
import com.mangofactory.swagger.ControllerDocumentation;
import com.mangofactory.swagger.Model;
import com.wordnik.swagger.core.DocumentationSchema;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Models {
    private static final Logger log = LoggerFactory.getLogger(Models.class);

    public static void maybeAddParameterTypeToModels(ControllerDocumentation controllerDocumentation, Class<?> parameterType, String dataType) {
        if (Models.isKnownType(parameterType)) {
            return;
        }
        if (parameterType.isArray()) {
            String componentType = parameterType.getComponentType().getSimpleName();
            if (Models.isComplexType(parameterType.getComponentType())) {
                controllerDocumentation.putModel(componentType, new Model(String.format("Array[%s]", componentType), parameterType.getComponentType()));
            }
        } else {
            controllerDocumentation.putModel(dataType, new Model(dataType, parameterType));
        }
    }

    private static boolean isKnownType(Class<?> parameterType) {
        return parameterType.isAssignableFrom(List.class) || parameterType.isAssignableFrom(Set.class) || parameterType.isPrimitive() || parameterType.isEnum() || parameterType.isAssignableFrom(String.class) || parameterType.isAssignableFrom(Date.class);
    }

    private static boolean isComplexType(Class<?> parameterType) {
        return !parameterType.isEnum() && !parameterType.isPrimitive() && !parameterType.isArray() && !parameterType.isAssignableFrom(List.class) && !parameterType.isAssignableFrom(Set.class) && !parameterType.isAssignableFrom(String.class) && !parameterType.isAssignableFrom(Date.class);
    }

    public static class Fn {
        private Fn() {
            throw new UnsupportedOperationException();
        }

        public static Function<Model, DocumentationSchema> modelToSchema() {
            return new Function<Model, DocumentationSchema>(){

                public DocumentationSchema apply(Model input) {
                    ObjectMapper mapper = new ObjectMapper();
                    mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                    mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                    DocumentationSchema schema = new DocumentationSchema();
                    schema.setId(input.getName());
                    try {
                        JsonSchema jsonSchema = mapper.generateJsonSchema(input.getType());
                        ObjectWriter writer = mapper.writer();
                        StringWriter stringWriter = new StringWriter();
                        writer.writeValue((Writer)stringWriter, (Object)jsonSchema);
                        String schemaAsString = ((Object)stringWriter).toString();
                        schema.setItems((DocumentationSchema)mapper.readValue(schemaAsString, DocumentationSchema.class));
                        return Fn.fixup(schema);
                    }
                    catch (IOException e) {
                        return schema;
                    }
                    catch (StackOverflowError e) {
                        log.error(String.format("Unable to serialize: %s -> %s", input.getName(), input.getType()));
                        return schema;
                    }
                }
            };
        }

        private static DocumentationSchema fixup(DocumentationSchema schema) {
            DocumentationSchema fixup = new DocumentationSchema();
            fixup.setId(schema.getId());
            fixup.setProperties(schema.getItems().getProperties());
            return fixup;
        }
    }
}

