/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.filters;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.mangofactory.swagger.ControllerDocumentation;
import com.mangofactory.swagger.SwaggerConfiguration;
import com.mangofactory.swagger.annotations.Annotations;
import com.mangofactory.swagger.annotations.ApiModel;
import com.mangofactory.swagger.filters.Filter;
import com.mangofactory.swagger.filters.FilterContext;
import com.mangofactory.swagger.models.Model;
import com.mangofactory.swagger.models.ResolvedTypes;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.core.DocumentationOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;

public class AnnotatedOperationFilter
implements Filter<DocumentationOperation> {
    private static final Logger log = LoggerFactory.getLogger(AnnotatedOperationFilter.class);

    @Override
    public void apply(FilterContext<DocumentationOperation> context) {
        DocumentationOperation operation = context.subject();
        HandlerMethod handlerMethod = (HandlerMethod)context.get("handlerMethod");
        ControllerDocumentation controllerDocumentation = (ControllerDocumentation)((Object)context.get("controllerDocumentation"));
        SwaggerConfiguration swaggerConfiguration = (SwaggerConfiguration)context.get("swaggerConfiguration");
        this.documentOperation(controllerDocumentation, operation, handlerMethod, swaggerConfiguration);
    }

    private void documentOperation(ControllerDocumentation controllerDocumentation, DocumentationOperation operation, HandlerMethod handlerMethod, SwaggerConfiguration configuration) {
        ApiModel apiModel;
        ApiOperation apiOperation = (ApiOperation)handlerMethod.getMethodAnnotation(ApiOperation.class);
        ResolvedType resolvedType = null;
        ResolvedType parameterType = ResolvedTypes.methodReturnType(configuration.getTypeResolver(), handlerMethod.getMethod());
        if (parameterType != null) {
            resolvedType = configuration.maybeGetAlternateType(parameterType);
        }
        if (apiOperation != null) {
            operation.setSummary(apiOperation.value());
            operation.setNotes(apiOperation.notes());
            if (resolvedType != null && resolvedType.getErasedType() == null) {
                if (apiOperation.multiValueResponse()) {
                    operation.setResponseClass(String.format("Array[%s]", apiOperation.responseClass()));
                } else {
                    operation.setResponseClass(apiOperation.responseClass());
                }
            }
            operation.setTags((List)Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().split((CharSequence)apiOperation.tags())));
        }
        if ((apiModel = (ApiModel)handlerMethod.getMethodAnnotation(ApiModel.class)) != null) {
            if (resolvedType == null || Objects.equal((Object)resolvedType.getErasedType(), (Object)Annotations.getAnnotatedType(apiModel))) {
                operation.setResponseClass(Annotations.getAnnotatedType(apiModel));
                String simpleName = apiModel.type().getSimpleName();
                controllerDocumentation.putModel(simpleName, new Model(simpleName, ResolvedTypes.asResolvedType(apiModel.type()), true));
            } else {
                log.warn("Api Model override does not match the resolved type");
            }
        }
    }
}

