/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.filters;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.mangofactory.swagger.ControllerDocumentation;
import com.mangofactory.swagger.annotations.Annotations;
import com.mangofactory.swagger.annotations.ApiModel;
import com.mangofactory.swagger.filters.Filter;
import com.mangofactory.swagger.filters.FilterContext;
import com.mangofactory.swagger.models.Model;
import com.mangofactory.swagger.models.ResolvedTypes;
import com.mangofactory.swagger.spring.AllowableRangesParser;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.core.DocumentationAllowableListValues;
import com.wordnik.swagger.core.DocumentationAllowableValues;
import com.wordnik.swagger.core.DocumentationParameter;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;

public class AnnotatedParameterFilter
implements Filter<DocumentationParameter> {
    private static final Logger log = LoggerFactory.getLogger(AnnotatedParameterFilter.class);

    @Override
    public void apply(FilterContext<DocumentationParameter> context) {
        DocumentationParameter parameter = context.subject();
        MethodParameter methodParameter = (MethodParameter)context.get("methodParameter");
        ControllerDocumentation controllerDocumentation = (ControllerDocumentation)((Object)context.get("controllerDocumentation"));
        ResolvedType resolvedType = (ResolvedType)context.get("parameterType");
        this.documentParameter(controllerDocumentation, parameter, methodParameter, resolvedType);
    }

    private void documentParameter(ControllerDocumentation controllerDocumentation, DocumentationParameter parameter, MethodParameter methodParameter, ResolvedType resolvedType) {
        ApiParam apiParam = (ApiParam)methodParameter.getParameterAnnotation(ApiParam.class);
        if (apiParam == null) {
            log.warn("{} is missing @ApiParam annotation - so generating default documentation", (Object)methodParameter.getMethod());
            return;
        }
        DocumentationAllowableValues allowableValues = this.convertToAllowableValues(apiParam.allowableValues());
        String description = apiParam.value();
        boolean isRequired = apiParam.required();
        String name = this.selectBestParameterName(methodParameter);
        if (!Strings.isNullOrEmpty((String)name)) {
            parameter.setName(name);
        }
        if (!Strings.isNullOrEmpty((String)description)) {
            parameter.setDescription(description);
        }
        parameter.setNotes(apiParam.internalDescription());
        parameter.setDefaultValue(apiParam.defaultValue());
        parameter.setAllowableValues(allowableValues);
        parameter.setRequired(isRequired);
        parameter.setAllowMultiple(apiParam.allowMultiple());
        ApiModel apiModel = (ApiModel)methodParameter.getParameterAnnotation(ApiModel.class);
        if (apiModel != null) {
            if (Objects.equal((Object)resolvedType.getErasedType(), (Object)Annotations.getAnnotatedType(apiModel))) {
                parameter.setDataType(Annotations.getAnnotatedType(apiModel));
                String simpleName = apiModel.type().getSimpleName();
                controllerDocumentation.putModel(simpleName, new Model(simpleName, ResolvedTypes.asResolvedType(apiModel.type())));
            } else {
                log.warn("Api Model override does not match the resolved type");
            }
        }
    }

    private String selectBestParameterName(MethodParameter methodParameter) {
        ApiParam apiParam = (ApiParam)methodParameter.getParameterAnnotation(ApiParam.class);
        if (apiParam != null && !StringUtils.isEmpty((String)apiParam.name())) {
            return apiParam.name();
        }
        return methodParameter.getParameterName();
    }

    protected DocumentationAllowableValues convertToAllowableValues(String csvString) {
        if (csvString.toLowerCase().startsWith("range[")) {
            String[] ranges = csvString.substring(6, csvString.length() - 1).split(",");
            return AllowableRangesParser.buildAllowableRangeValues(ranges, csvString);
        }
        if (csvString.toLowerCase().startsWith("rangeexclusive[")) {
            String[] ranges = csvString.substring(15, csvString.length() - 1).split(",");
            return AllowableRangesParser.buildAllowableRangeValues(ranges, csvString);
        }
        if (csvString == null || csvString.length() == 0) {
            return null;
        }
        List<String> params = Arrays.asList(csvString.split(","));
        return new DocumentationAllowableListValues(params);
    }
}

