/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.members.ResolvedField;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.mangofactory.swagger.models.EnumHelper;
import com.mangofactory.swagger.models.MemberInfoSource;
import com.mangofactory.swagger.models.MemberVisitor;
import com.mangofactory.swagger.models.Models;
import com.mangofactory.swagger.models.PrimitiveMemberInfo;
import com.mangofactory.swagger.models.PrimitiveMemberVisitor;
import com.mangofactory.swagger.models.ResolvedCollection;
import com.mangofactory.swagger.models.ResolvedProperty;
import com.mangofactory.swagger.models.ResolvedTypes;
import com.mangofactory.swagger.models.SchemaProvider;
import com.wordnik.swagger.core.DocumentationAllowableListValues;
import com.wordnik.swagger.core.DocumentationAllowableValues;
import com.wordnik.swagger.core.DocumentationSchema;
import java.util.HashMap;
import java.util.Map;

public class ResolvedTypeMemberVisitor
implements MemberVisitor {
    private final SchemaProvider context;

    public ResolvedTypeMemberVisitor(SchemaProvider context) {
        this.context = context;
    }

    public static Function<SchemaProvider, MemberVisitor> factory() {
        return new Function<SchemaProvider, MemberVisitor>(){

            public MemberVisitor apply(SchemaProvider input) {
                return new ResolvedTypeMemberVisitor(input);
            }
        };
    }

    @Override
    public DocumentationSchema schema(MemberInfoSource member) {
        if (this.context.getSchemaMap().containsKey(member.getType().getSimpleName())) {
            DocumentationSchema schema = new DocumentationSchema();
            schema.setType(ResolvedTypes.modelName(member.getResolvedType()));
            schema.setName(member.getName());
            return schema;
        }
        ResolvedType resolvedMember = member.getResolvedType();
        Class erasedClass = resolvedMember.getErasedType();
        if (resolvedMember.getTypeParameters().size() == 0) {
            if (resolvedMember.isPrimitive() || Models.isPrimitive(resolvedMember.getErasedType())) {
                return ((MemberVisitor)PrimitiveMemberVisitor.factory().apply((Object)this.context)).schema(new PrimitiveMemberInfo(erasedClass));
            }
            if (EnumHelper.isEnum(resolvedMember.getErasedType())) {
                DocumentationSchema schema = new DocumentationSchema();
                schema.setType(ResolvedTypes.modelName(resolvedMember));
                schema.setName(resolvedMember.getErasedType().getName());
                DocumentationAllowableListValues list = new DocumentationAllowableListValues();
                list.setValues(EnumHelper.getEnumValues(resolvedMember.getErasedType()));
                schema.setAllowableValues((DocumentationAllowableValues)list);
                schema.setProperties(new HashMap());
                this.context.getSchemaMap().put(schema.getType(), schema);
                return schema;
            }
            if (resolvedMember.getErasedType() == Object.class) {
                return null;
            }
        }
        if (ResolvedCollection.isList(member)) {
            DocumentationSchema schema = new DocumentationSchema();
            schema.setType("List");
            schema.setName(member.getName());
            ResolvedType resolvedType = ResolvedCollection.listElementType(member);
            DocumentationSchema itemSchema = this.context.schema(resolvedType);
            DocumentationSchema itemSchemaRef = new DocumentationSchema();
            if (itemSchema != null) {
                itemSchemaRef.ref_$eq(itemSchema.getType());
            } else {
                itemSchemaRef.ref_$eq("any");
            }
            schema.setItems(itemSchemaRef);
            return schema;
        }
        if (ResolvedCollection.isSet(member)) {
            DocumentationSchema schema = new DocumentationSchema();
            schema.setType("Set");
            schema.setName(member.getName());
            ResolvedType resolvedType = ResolvedCollection.setElementType(member);
            DocumentationSchema itemSchema = this.context.schema(resolvedType);
            DocumentationSchema itemSchemaRef = new DocumentationSchema();
            if (itemSchema != null) {
                itemSchemaRef.ref_$eq(itemSchema.getType());
            } else {
                itemSchemaRef.ref_$eq("any");
            }
            schema.setItems(itemSchemaRef);
            return schema;
        }
        DocumentationSchema objectSchema = new DocumentationSchema();
        objectSchema.setName(member.getName());
        objectSchema.setType(ResolvedTypes.modelName(resolvedMember));
        this.context.getSchemaMap().put(resolvedMember.getErasedType().getSimpleName(), objectSchema);
        HashMap propertyMap = Maps.newHashMap();
        for (ResolvedField childField : this.context.getResolvedFields(resolvedMember)) {
            DocumentationSchema childSchema = this.context.schema(childField);
            if (childSchema == null) continue;
            propertyMap.put(childField.getName(), childSchema);
        }
        for (ResolvedProperty childProperty : this.context.getResolvedProperties(resolvedMember)) {
            DocumentationSchema childPropertySchema = this.context.schema(childProperty);
            if (childPropertySchema == null) continue;
            propertyMap.put(childProperty.getName(), childPropertySchema);
        }
        objectSchema.setProperties((Map)propertyMap);
        return objectSchema;
    }
}

