/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.spring;

import com.google.common.collect.Maps;
import com.mangofactory.swagger.ControllerDocumentation;
import com.mangofactory.swagger.SwaggerConfiguration;
import com.mangofactory.swagger.spring.ControllerAdapter;
import com.mangofactory.swagger.spring.DocumentationEndPoints;
import com.mangofactory.swagger.spring.EndpointReader;
import com.mangofactory.swagger.spring.OperationReader;
import com.mangofactory.swagger.spring.UriExtractor;
import com.wordnik.swagger.core.Documentation;
import com.wordnik.swagger.core.DocumentationEndPoint;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.ParamsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class DocumentationReader {
    private static final Logger log = LoggerFactory.getLogger(DocumentationReader.class);
    private static final List<RequestMethod> allRequestMethods = Arrays.asList(RequestMethod.GET, RequestMethod.DELETE, RequestMethod.POST, RequestMethod.PUT);
    private final SwaggerConfiguration configuration;
    private final Map<String, DocumentationEndPoint> endpointLookup = Maps.newHashMap();
    private final Map<String, ControllerDocumentation> resourceDocumentationLookup = Maps.newHashMap();
    private final EndpointReader endpointReader;
    private final OperationReader operationReader;
    private RequestMappingHandlerMapping handlerMapping;
    private Documentation documentation;

    public DocumentationReader(SwaggerConfiguration swaggerConfiguration, WebApplicationContext context, RequestMappingHandlerMapping handlerMapping) {
        this.configuration = swaggerConfiguration;
        this.handlerMapping = handlerMapping;
        this.endpointReader = new EndpointReader(this.configuration);
        this.operationReader = new OperationReader(this.configuration);
        this.buildMappingDocuments(context);
    }

    private void buildMappingDocuments(WebApplicationContext context) {
        this.documentation = this.configuration.newDocumentation(context);
        this.processMethod(this.handlerMapping);
    }

    private ControllerDocumentation addChildDocumentIfMissing(ControllerAdapter resource, ControllerDocumentation resourceDocumentation) {
        if (!this.resourceDocumentationLookup.containsKey(UriExtractor.getDocumentationEndpointUri(resource.getControllerClass()))) {
            this.resourceDocumentationLookup.put(UriExtractor.getDocumentationEndpointUri(resource.getControllerClass()), resourceDocumentation);
        }
        return this.resourceDocumentationLookup.get(UriExtractor.getDocumentationEndpointUri(resource.getControllerClass()));
    }

    private DocumentationEndPoint addEndpointDocumentationIfMissing(ControllerAdapter resource) {
        if (this.endpointLookup.containsKey(UriExtractor.getDocumentationEndpointUri(resource.getControllerClass()))) {
            return this.endpointLookup.get(UriExtractor.getDocumentationEndpointUri(resource.getControllerClass()));
        }
        DocumentationEndPoint endpoint = resource.describeAsDocumentationEndpoint();
        if (endpoint != null) {
            this.endpointLookup.put(UriExtractor.getDocumentationEndpointUri(resource.getControllerClass()), endpoint);
            log.debug("Added resource listing: {}", (Object)resource.toString());
            this.documentation.addApi(endpoint);
        }
        return endpoint;
    }

    private void processMethod(RequestMappingHandlerMapping handlerMapping) {
        for (Map.Entry entry : handlerMapping.getHandlerMethods().entrySet()) {
            HandlerMethod handlerMethod = (HandlerMethod)entry.getValue();
            RequestMappingInfo mappingInfo = (RequestMappingInfo)entry.getKey();
            ControllerAdapter resource = new ControllerAdapter(this.documentation, handlerMethod, this.configuration);
            if (resource.shouldSkipDocumentation()) continue;
            DocumentationEndPoint endPoint = this.addEndpointDocumentationIfMissing(resource);
            ControllerDocumentation controllerDocumentation = this.addChildDocumentIfMissing(resource, DocumentationEndPoints.asDocumentation(this.documentation, endPoint, resource, this.configuration.getSchemaProvider()));
            for (String requestUri : mappingInfo.getPatternsCondition().getPatterns()) {
                DocumentationEndPoint childEndPoint = this.endpointReader.readEndpoint(handlerMethod, resource, requestUri);
                controllerDocumentation.addEndpoint(childEndPoint);
                this.appendOperationsToEndpoint(controllerDocumentation, mappingInfo, handlerMethod, childEndPoint, mappingInfo.getParamsCondition());
            }
        }
    }

    private void appendOperationsToEndpoint(ControllerDocumentation controllerDocumentation, RequestMappingInfo mappingInfo, HandlerMethod handlerMethod, DocumentationEndPoint endPoint, ParamsRequestCondition paramsCondition) {
        if (mappingInfo.getMethodsCondition().getMethods().isEmpty()) {
            this.appendOperationsToEndpoint(controllerDocumentation, handlerMethod, endPoint, allRequestMethods, paramsCondition);
        } else {
            this.appendOperationsToEndpoint(controllerDocumentation, handlerMethod, endPoint, mappingInfo.getMethodsCondition().getMethods(), paramsCondition);
        }
    }

    private void appendOperationsToEndpoint(ControllerDocumentation controllerDocumentation, HandlerMethod handlerMethod, DocumentationEndPoint endPoint, Collection<RequestMethod> methods, ParamsRequestCondition paramsCondition) {
        for (RequestMethod requestMethod : methods) {
            endPoint.addOperation(this.operationReader.readOperation(controllerDocumentation, handlerMethod, paramsCondition, requestMethod));
        }
    }

    public ControllerDocumentation getDocumentation(String apiName) {
        for (ControllerDocumentation documentation : this.resourceDocumentationLookup.values()) {
            if (!documentation.matchesName(apiName).booleanValue()) continue;
            return documentation;
        }
        log.error("Could not find a matching resource for api with name '" + apiName + "'");
        return null;
    }

    public RequestMappingHandlerMapping getHandlerMapping() {
        return this.handlerMapping;
    }

    public Documentation getDocumentation() {
        return this.documentation;
    }
}

