/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.spring;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mangofactory.swagger.ControllerDocumentation;
import com.mangofactory.swagger.SwaggerConfiguration;
import com.mangofactory.swagger.filters.FilterContext;
import com.mangofactory.swagger.filters.Filters;
import com.mangofactory.swagger.models.ResolvedTypes;
import com.wordnik.swagger.core.DocumentationAllowableListValues;
import com.wordnik.swagger.core.DocumentationAllowableValues;
import com.wordnik.swagger.core.DocumentationError;
import com.wordnik.swagger.core.DocumentationOperation;
import com.wordnik.swagger.core.DocumentationParameter;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;
import org.springframework.web.servlet.mvc.condition.ParamsRequestCondition;

public class OperationReader {
    private final SwaggerConfiguration configuration;

    public OperationReader(SwaggerConfiguration configuration) {
        this.configuration = configuration;
    }

    DocumentationOperation readOperation(ControllerDocumentation controllerDocumentation, HandlerMethod handlerMethod, ParamsRequestCondition paramsCondition, RequestMethod requestMethod) {
        DocumentationOperation operation = new DocumentationOperation(requestMethod.name(), "", "");
        FilterContext<DocumentationOperation> operationContext = new FilterContext<DocumentationOperation>(operation);
        operationContext.put("handlerMethod", handlerMethod);
        operationContext.put("controllerDocumentation", (Object)controllerDocumentation);
        operationContext.put("swaggerConfiguration", this.configuration);
        Filters.Fn.applyFilters(this.configuration.getOperationFilters(), operationContext);
        int parameterIndex = 0;
        List<ResolvedType> resolvedParameters = ResolvedTypes.methodParameters(this.configuration.getTypeResolver(), handlerMethod.getMethod());
        MethodParameter[] methodParameters = handlerMethod.getMethodParameters();
        String[] parameterNames = this.getParameterNames(handlerMethod, methodParameters.length);
        for (int index = 0; index < handlerMethod.getMethodParameters().length; ++index) {
            DocumentationParameter parameter = new DocumentationParameter();
            ResolvedType resolvedType = this.configuration.maybeGetAlternateType(resolvedParameters.get(index));
            if (resolvedParameters.size() == 0 || this.configuration.isParameterTypeIgnorable(resolvedType.getErasedType())) continue;
            FilterContext<DocumentationParameter> parameterContext = new FilterContext<DocumentationParameter>(parameter);
            parameterContext.put("methodParameter", methodParameters[index]);
            parameterContext.put("parameterType", resolvedType);
            parameterContext.put("defaultParameterName", parameterNames[parameterIndex++]);
            parameterContext.put("controllerDocumentation", (Object)controllerDocumentation);
            Filters.Fn.applyFilters(this.configuration.getParameterFilters(), parameterContext);
            operation.addParameter(parameter);
        }
        for (NameValueExpression expression : paramsCondition.getExpressions()) {
            if (expression.isNegated() || Iterables.any((Iterable)operation.getParameters(), this.withName(expression.getName()))) continue;
            DocumentationParameter parameter = new DocumentationParameter();
            parameter.setDataType("String");
            parameter.setName(expression.getName());
            parameter.setDefaultValue((String)expression.getValue());
            parameter.setRequired(true);
            parameter.setParamType("query");
            parameter.setAllowableValues((DocumentationAllowableValues)new DocumentationAllowableListValues((List)Lists.newArrayList((Object[])new String[]{(String)expression.getValue()})));
            operation.addParameter(parameter);
        }
        ArrayList errors = Lists.newArrayList();
        FilterContext<ArrayList> errorContext = new FilterContext<ArrayList>(errors);
        errorContext.put("handlerMethod", handlerMethod);
        Filters.Fn.applyFilters(this.configuration.getErrorFilters(), errorContext);
        for (DocumentationError error : errors) {
            operation.addErrorResponse(error);
        }
        return operation;
    }

    private String[] getParameterNames(HandlerMethod handlerMethod, int length) {
        String[] parameterNames = new LocalVariableTableParameterNameDiscoverer().getParameterNames(handlerMethod.getMethod());
        if (parameterNames == null) {
            parameterNames = new String[length];
            for (int index = 0; index < length; ++index) {
                parameterNames[index] = String.format("p%s", index);
            }
        }
        return parameterNames;
    }

    private Predicate<? super DocumentationParameter> withName(final String name) {
        return new Predicate<DocumentationParameter>(){

            public boolean apply(DocumentationParameter input) {
                return Objects.equal((Object)input.getName(), (Object)name);
            }
        };
    }
}

