/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models;

import com.fasterxml.classmate.MemberResolver;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import com.mangofactory.swagger.models.ResolvedProperty;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResolvedTypes {
    static Pattern getter = Pattern.compile("^get([a-zA-Z].*)");
    static Pattern isGetter = Pattern.compile("^is([a-zA-Z].*)");
    static Pattern setter = Pattern.compile("^set([a-zA-Z].*)");

    static String toCamelCase(String s) {
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    public static boolean isGetter(Method method) {
        if (method.getParameterTypes().length == 0) {
            if (method.getName().matches("^get[a-zA-Z].*") && !method.getReturnType().equals(Void.TYPE)) {
                return true;
            }
            if (method.getName().matches("^is[a-zA-Z].*") && method.getReturnType().equals(Boolean.TYPE)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isSetter(Method method) {
        return method.getReturnType().equals(Void.TYPE) && method.getParameterTypes().length == 1 && method.getName().matches("^set[a-zA-Z].*");
    }

    public static String propertyName(String methodName) {
        Preconditions.checkNotNull((Object)methodName);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)methodName) ? 1 : 0) != 0);
        Matcher matcher = getter.matcher(methodName);
        if (matcher.matches()) {
            return ResolvedTypes.toCamelCase(matcher.group(1));
        }
        matcher = isGetter.matcher(methodName);
        if (matcher.matches()) {
            return ResolvedTypes.toCamelCase(matcher.group(1));
        }
        matcher = setter.matcher(methodName);
        if (matcher.matches()) {
            return ResolvedTypes.toCamelCase(matcher.group(1));
        }
        throw new IllegalArgumentException(String.format("Method (%s) is not a getter or a setter", methodName));
    }

    public static List<ResolvedProperty> gettersAndSetters(TypeResolver typeResolver, ResolvedType resolvedType) {
        MemberResolver resolver = new MemberResolver(typeResolver);
        resolver.setIncludeLangObject(false);
        ResolvedTypeWithMembers typeWithMembers = resolver.resolve(resolvedType, null, null);
        Iterable filteredProperties = Iterables.filter((Iterable)Lists.newArrayList((Object[])typeWithMembers.getMemberMethods()), (Predicate)new Predicate<ResolvedMethod>(){

            public boolean apply(ResolvedMethod input) {
                return ResolvedTypes.isGetter(input.getRawMember()) || ResolvedTypes.isSetter(input.getRawMember());
            }
        });
        return Lists.transform((List)Lists.newArrayList((Iterable)filteredProperties), (Function)new Function<ResolvedMethod, ResolvedProperty>(){

            public ResolvedProperty apply(ResolvedMethod input) {
                return new ResolvedProperty(ResolvedTypes.propertyName(input.getRawMember().getName()), input, ResolvedTypes.isGetter(input.getRawMember()));
            }
        });
    }

    public static List<ResolvedType> methodParameters(TypeResolver typeResolver, Method methodToResolve) {
        ResolvedMethod resolvedMethod = ResolvedTypes.getResolvedMethod(typeResolver, methodToResolve);
        ArrayList parameters = Lists.newArrayList();
        if (resolvedMethod != null) {
            for (int index = 0; index < resolvedMethod.getArgumentCount(); ++index) {
                parameters.add(resolvedMethod.getArgumentType(index));
            }
        }
        return parameters;
    }

    public static ResolvedType methodReturnType(TypeResolver typeResolver, Method methodToResolve) {
        ResolvedMethod resolvedMethod = ResolvedTypes.getResolvedMethod(typeResolver, methodToResolve);
        if (resolvedMethod != null) {
            return resolvedMethod.getReturnType();
        }
        return ResolvedTypes.asResolvedType(methodToResolve.getReturnType());
    }

    private static ResolvedMethod getResolvedMethod(TypeResolver typeResolver, final Method methodToResolve) {
        ResolvedType enclosingType = typeResolver.resolve(methodToResolve.getDeclaringClass(), new Type[0]);
        MemberResolver resolver = new MemberResolver(typeResolver);
        resolver.setIncludeLangObject(false);
        ResolvedTypeWithMembers typeWithMembers = resolver.resolve(enclosingType, null, null);
        Iterable filtered = Iterables.filter((Iterable)Lists.newArrayList((Object[])typeWithMembers.getMemberMethods()), (Predicate)new Predicate<ResolvedMethod>(){

            public boolean apply(ResolvedMethod input) {
                return input.getRawMember().getName().equals(methodToResolve.getName());
            }
        });
        return ResolvedTypes.resolveToMethodWithMaxResolvedTypes(filtered);
    }

    private static ResolvedMethod resolveToMethodWithMaxResolvedTypes(Iterable<ResolvedMethod> filtered) {
        if (Iterables.size(filtered) > 0) {
            return (ResolvedMethod)Ordering.from((Comparator)new Comparator<ResolvedMethod>(){

                @Override
                public int compare(ResolvedMethod first, ResolvedMethod second) {
                    return Ints.compare((int)first.getArgumentCount(), (int)second.getArgumentCount());
                }
            }).max(filtered);
        }
        return null;
    }

    public static ResolvedType asResolvedType(Class clazz) {
        return new TypeResolver().resolve((Type)clazz, new Type[0]);
    }

    public static ResolvedType asResolvedType(TypeResolver typeResolver, Class clazz) {
        return typeResolver.resolve((Type)clazz, new Type[0]);
    }

    public static String modelName(ResolvedType resolvedType) {
        StringBuilder sb = new StringBuilder();
        sb.append(resolvedType.getErasedType().getSimpleName());
        boolean first = true;
        for (ResolvedType typeParam : resolvedType.getTypeParameters()) {
            if (first) {
                sb.append(String.format("[%s", typeParam.getErasedType().getSimpleName()));
                first = false;
                continue;
            }
            sb.append(String.format(",%s", typeParam.getErasedType().getSimpleName()));
        }
        if (!first) {
            sb.append("]");
        }
        return sb.toString();
    }
}

