/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models;

import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mangofactory.swagger.models.Jackson2SchemaDescriptor;
import com.mangofactory.swagger.models.Model;
import com.mangofactory.swagger.models.SchemaDescriptor;
import com.mangofactory.swagger.models.SchemaProvider;
import com.wordnik.swagger.core.DocumentationSchema;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DocumentationSchemaProvider {
    private static final Logger log = LoggerFactory.getLogger(DocumentationSchemaProvider.class);
    private final SchemaDescriptor descriptor;
    private TypeResolver typeResolver;

    @Autowired
    public DocumentationSchemaProvider(TypeResolver typeResolver, SchemaDescriptor descriptor) {
        this.typeResolver = typeResolver;
        this.descriptor = descriptor;
    }

    public DocumentationSchemaProvider(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
        this.descriptor = new Jackson2SchemaDescriptor(new ObjectMapper());
    }

    public Map<String, DocumentationSchema> getModelMap(Model model) {
        SchemaProvider providers = new SchemaProvider(this.descriptor, this.typeResolver, model.isReturnType());
        providers.schema(model.getType());
        return providers.getSchemaMap();
    }
}

