/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.spring;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.mangofactory.swagger.SwaggerConfiguration;
import com.mangofactory.swagger.annotations.ApiIgnore;
import com.mangofactory.swagger.annotations.ApiInclude;
import com.mangofactory.swagger.spring.UriBuilder;
import com.mangofactory.swagger.spring.UriExtractor;
import com.mangofactory.swagger.spring.controller.DocumentationController;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.core.Documentation;
import com.wordnik.swagger.core.DocumentationEndPoint;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;
import org.springframework.web.method.HandlerMethod;

public class ControllerAdapter {
    private static final Logger log = LoggerFactory.getLogger(ControllerAdapter.class);
    private final HandlerMethod handlerMethod;
    private final Class<?> controllerClass;
    private final SwaggerConfiguration configuration;
    private Documentation parent;

    public ControllerAdapter(Documentation parent, HandlerMethod handlerMethod, SwaggerConfiguration configuration) {
        this.parent = parent;
        this.handlerMethod = handlerMethod;
        this.configuration = configuration;
        this.controllerClass = ClassUtils.getUserClass((Class)this.handlerMethod.getBeanType());
    }

    public List<DocumentationEndPoint> describeAsDocumentationEndpoints() {
        ArrayList endpoints = Lists.newArrayList();
        for (String listingPath : this.getListingPaths()) {
            String documentationUri = new UriBuilder(this.configuration.getDocumentationBasePath()).appendPath(listingPath).toString();
            endpoints.add(new DocumentationEndPoint(documentationUri, this.getApiDescription(this.controllerClass)));
        }
        return endpoints;
    }

    private List<String> getListingPaths() {
        Api apiAnnotation = this.controllerClass.getAnnotation(Api.class);
        if (apiAnnotation == null || apiAnnotation.listingPath().equals("")) {
            return UriExtractor.controllerUris(this.controllerClass);
        }
        return Lists.newArrayList((Object[])new String[]{apiAnnotation.listingPath()});
    }

    private String getApiDescription(Class<?> controllerClass) {
        Api apiAnnotation = controllerClass.getAnnotation(Api.class);
        if (apiAnnotation == null) {
            return null;
        }
        return apiAnnotation.description();
    }

    public String toString() {
        return String.format("ApiResource for %s at [%s]", this.controllerClass.getSimpleName(), Joiner.on((String)",").skipNulls().join(UriExtractor.controllerUris(this.controllerClass)));
    }

    public Class<?> getControllerClass() {
        return this.controllerClass;
    }

    public boolean isInternalResource() {
        return this.controllerClass == DocumentationController.class;
    }

    public Documentation documentation() {
        return this.parent;
    }

    public boolean isIgnored() {
        ApiIgnore annotation = (ApiIgnore)this.handlerMethod.getMethodAnnotation(ApiIgnore.class);
        return annotation != null;
    }

    public boolean hasIncludeOverride() {
        ApiInclude annotation = (ApiInclude)this.handlerMethod.getMethodAnnotation(ApiInclude.class);
        return annotation != null;
    }

    public boolean shouldSkipDocumentation() {
        return this.isInternalResource() || this.excludedControllerIsNotExplicitlyIncluded() || this.isIgnored();
    }

    private boolean excludedControllerIsNotExplicitlyIncluded() {
        return this.configuration.isExcluded(UriExtractor.controllerUris(this.controllerClass)) && !this.hasIncludeOverride();
    }

    public HandlerMethod getHandlerMethod() {
        return this.handlerMethod;
    }
}

