/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mangofactory.swagger.DocumentationTransformer;
import com.mangofactory.swagger.filters.Filter;
import com.mangofactory.swagger.filters.FilterContext;
import com.mangofactory.swagger.filters.Filters;
import com.mangofactory.swagger.models.DocumentationSchemaProvider;
import com.mangofactory.swagger.models.ResolvedTypes;
import com.mangofactory.swagger.models.TypeProcessingRule;
import com.wordnik.swagger.core.Documentation;
import com.wordnik.swagger.core.DocumentationEndPoint;
import com.wordnik.swagger.core.DocumentationError;
import com.wordnik.swagger.core.DocumentationOperation;
import com.wordnik.swagger.core.DocumentationParameter;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.WebApplicationContext;

public class SwaggerConfiguration {
    public static final String API_DOCS_PATH = "/api-docs";
    public static final String SWAGGER_VERSION = "1.0";
    private final String documentationBasePath;
    private final String swaggerVersion;
    private String apiVersion;
    private String basePath;
    private List<String> excludedResources = Lists.newArrayList();
    private final List<Filter<Documentation>> documentationFilters = Lists.newArrayList();
    private final List<Filter<DocumentationEndPoint>> endpointFilters = Lists.newArrayList();
    private final List<Filter<DocumentationOperation>> operationFilters = Lists.newArrayList();
    private final List<Filter<DocumentationParameter>> parameterFilters = Lists.newArrayList();
    private final List<Filter<List<DocumentationError>>> errorFilters = Lists.newArrayList();
    private final List<TypeProcessingRule> typeProcessingRules = Lists.newArrayList();
    @Autowired
    private DocumentationTransformer documentationTransformer;
    @Autowired
    private DocumentationSchemaProvider schemaProvider;
    @Autowired
    private TypeResolver typeResolver;

    public SwaggerConfiguration(String apiVersion, String basePath) {
        this.swaggerVersion = SWAGGER_VERSION;
        this.documentationBasePath = API_DOCS_PATH;
        this.basePath = basePath;
        this.apiVersion = apiVersion;
    }

    public Documentation newDocumentation(WebApplicationContext webApplicationContext) {
        FilterContext<Documentation> context = new FilterContext<Documentation>(new Documentation(null, this.swaggerVersion, this.basePath, null));
        context.put("swagger", this);
        context.put("webApplicationContext", webApplicationContext);
        Filters.Fn.applyFilters(this.documentationFilters, context);
        return context.subject();
    }

    public boolean isExcluded(List<String> documentationEndpointUris) {
        if (documentationEndpointUris == null) {
            return false;
        }
        for (String uri : documentationEndpointUris) {
            if (Strings.isNullOrEmpty((String)uri)) {
                return false;
            }
            String controllerUri = uri;
            if (uri.contains(API_DOCS_PATH)) {
                controllerUri = uri.substring(API_DOCS_PATH.length());
            }
            if (!this.excludedResources.contains(controllerUri)) continue;
            return true;
        }
        return false;
    }

    public boolean isParameterTypeIgnorable(ResolvedType type) {
        TypeProcessingRule rule = this.findProcessingRule(type);
        return rule.isIgnorable();
    }

    public ResolvedType maybeGetAlternateType(ResolvedType parameterType) {
        TypeProcessingRule rule = this.findProcessingRule(parameterType);
        if (rule.hasAlternateType()) {
            return rule.alternateType();
        }
        return parameterType;
    }

    private TypeProcessingRule findProcessingRule(final ResolvedType parameterType) {
        return (TypeProcessingRule)Iterables.find(this.typeProcessingRules, (Predicate)new Predicate<TypeProcessingRule>(){

            public boolean apply(TypeProcessingRule input) {
                return input.originalType().equals((Object)parameterType);
            }
        }, (Object)new DefaultProcessingRule(parameterType.getErasedType()));
    }

    public DocumentationSchemaProvider getSchemaProvider() {
        if (this.schemaProvider == null) {
            this.schemaProvider = new DocumentationSchemaProvider(this.getTypeResolver());
        }
        return this.schemaProvider;
    }

    public TypeResolver getTypeResolver() {
        if (this.typeResolver == null) {
            this.typeResolver = new TypeResolver();
        }
        return this.typeResolver;
    }

    public String getDocumentationBasePath() {
        return this.documentationBasePath;
    }

    public String getSwaggerVersion() {
        return this.swaggerVersion;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public List<String> getExcludedResources() {
        return this.excludedResources;
    }

    public List<Filter<Documentation>> getDocumentationFilters() {
        return this.documentationFilters;
    }

    public List<Filter<DocumentationEndPoint>> getEndpointFilters() {
        return this.endpointFilters;
    }

    public List<Filter<DocumentationOperation>> getOperationFilters() {
        return this.operationFilters;
    }

    public List<Filter<DocumentationParameter>> getParameterFilters() {
        return this.parameterFilters;
    }

    public List<Filter<List<DocumentationError>>> getErrorFilters() {
        return this.errorFilters;
    }

    public List<TypeProcessingRule> getTypeProcessingRules() {
        return this.typeProcessingRules;
    }

    public DocumentationTransformer getDocumentationTransformer() {
        return this.documentationTransformer;
    }

    static class DefaultProcessingRule
    implements TypeProcessingRule {
        private Class<?> clazz;

        public DefaultProcessingRule(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public boolean isIgnorable() {
            return false;
        }

        @Override
        public boolean hasAlternateType() {
            return false;
        }

        @Override
        public ResolvedType originalType() {
            return ResolvedTypes.asResolvedType(this.clazz);
        }

        @Override
        public ResolvedType alternateType() {
            return ResolvedTypes.asResolvedType(this.clazz);
        }
    }
}

