/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.spring;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mangofactory.swagger.ControllerDocumentation;
import com.mangofactory.swagger.SwaggerConfiguration;
import com.mangofactory.swagger.spring.ControllerAdapter;
import com.mangofactory.swagger.spring.DocumentationEndPoints;
import com.mangofactory.swagger.spring.EndpointReader;
import com.mangofactory.swagger.spring.OperationReader;
import com.wordnik.swagger.core.Documentation;
import com.wordnik.swagger.core.DocumentationEndPoint;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.ParamsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class DocumentationReader {
    private static final Logger log = LoggerFactory.getLogger(DocumentationReader.class);
    private static final List<RequestMethod> allRequestMethods = Arrays.asList(RequestMethod.GET, RequestMethod.DELETE, RequestMethod.POST, RequestMethod.PUT);
    private final SwaggerConfiguration configuration;
    private final Map<String, DocumentationEndPoint> endpointByControllerLookup = Maps.newHashMap();
    private final Map<String, DocumentationEndPoint> endpointLookup = Maps.newHashMap();
    private final Map<String, ControllerDocumentation> resourceDocumentationLookup = Maps.newHashMap();
    private final EndpointReader endpointReader;
    private final OperationReader operationReader;
    private final WebApplicationContext context;
    private boolean isMappingBuilt = false;
    private List<RequestMappingHandlerMapping> handlerMappings;
    private Documentation documentation;

    public DocumentationReader(SwaggerConfiguration swaggerConfiguration, WebApplicationContext context, List<RequestMappingHandlerMapping> handlerMappings) {
        this.configuration = swaggerConfiguration;
        this.context = context;
        this.handlerMappings = handlerMappings;
        this.endpointReader = new EndpointReader(this.configuration);
        this.operationReader = new OperationReader(this.configuration);
    }

    private void buildMappingDocuments(WebApplicationContext context) {
        this.documentation = this.configuration.newDocumentation(context);
        for (RequestMappingHandlerMapping handlerMapping : this.handlerMappings) {
            this.processMethod(handlerMapping);
        }
        this.isMappingBuilt = true;
    }

    private ControllerDocumentation addChildDocumentIfMissing(ControllerDocumentation resourceDocumentation) {
        if (!this.resourceDocumentationLookup.containsKey(resourceDocumentation.getResourcePath())) {
            this.resourceDocumentationLookup.put(resourceDocumentation.getResourcePath(), resourceDocumentation);
        }
        return this.resourceDocumentationLookup.get(resourceDocumentation.getResourcePath());
    }

    private List<DocumentationEndPoint> addEndpointDocumentationsIfMissing(ControllerAdapter resource) {
        String key;
        List<Object> endpoints = Lists.newArrayList();
        for (String string : resource.getControllerUris()) {
            key = String.format("%s-%s", resource.getControllerClass().getSimpleName(), string);
            if (!this.endpointByControllerLookup.containsKey(key)) continue;
            endpoints.add(this.endpointByControllerLookup.get(key));
        }
        if (!endpoints.isEmpty()) {
            return endpoints;
        }
        endpoints = resource.describeAsDocumentationEndpoints();
        for (DocumentationEndPoint documentationEndPoint : endpoints) {
            key = String.format("%s-%s", resource.getControllerClass().getSimpleName(), documentationEndPoint.path());
            if (this.endpointByControllerLookup.containsKey(key)) continue;
            this.endpointByControllerLookup.put(key, documentationEndPoint);
        }
        for (DocumentationEndPoint documentationEndPoint : endpoints) {
            if (this.endpointLookup.containsKey(this.toApiUri(documentationEndPoint.getPath()))) continue;
            this.endpointLookup.put(this.toApiUri(documentationEndPoint.getPath()), documentationEndPoint);
            this.documentation.addApi(documentationEndPoint);
        }
        return endpoints;
    }

    private String toApiUri(String path) {
        return path.substring(this.configuration.getDocumentationBasePath().length());
    }

    private void processMethod(RequestMappingHandlerMapping handlerMapping) {
        for (Map.Entry entry : handlerMapping.getHandlerMethods().entrySet()) {
            HandlerMethod handlerMethod = (HandlerMethod)entry.getValue();
            RequestMappingInfo mappingInfo = (RequestMappingInfo)entry.getKey();
            ControllerAdapter resource = new ControllerAdapter(this.documentation, handlerMethod, this.configuration);
            if (resource.shouldSkipDocumentation()) continue;
            for (DocumentationEndPoint endPoint : this.addEndpointDocumentationsIfMissing(resource)) {
                ControllerDocumentation controllerDocumentation = this.addChildDocumentIfMissing(DocumentationEndPoints.asDocumentation(this.documentation, this.toApiUri(endPoint.path()), this.configuration.getSchemaProvider()));
                for (String requestUri : mappingInfo.getPatternsCondition().getPatterns()) {
                    DocumentationEndPoint childEndPoint = this.endpointReader.readEndpoint(handlerMethod, resource, requestUri);
                    if (!requestUri.contains(controllerDocumentation.getResourcePath())) continue;
                    controllerDocumentation.addEndpoint(childEndPoint);
                    this.appendOperationsToEndpoint(controllerDocumentation, mappingInfo, handlerMethod, childEndPoint, mappingInfo.getParamsCondition());
                }
            }
        }
    }

    private void appendOperationsToEndpoint(ControllerDocumentation controllerDocumentation, RequestMappingInfo mappingInfo, HandlerMethod handlerMethod, DocumentationEndPoint endPoint, ParamsRequestCondition paramsCondition) {
        if (mappingInfo.getMethodsCondition().getMethods().isEmpty()) {
            this.appendOperationsToEndpoint(controllerDocumentation, handlerMethod, endPoint, allRequestMethods, paramsCondition);
        } else {
            this.appendOperationsToEndpoint(controllerDocumentation, handlerMethod, endPoint, mappingInfo.getMethodsCondition().getMethods(), paramsCondition);
        }
    }

    private void appendOperationsToEndpoint(ControllerDocumentation controllerDocumentation, HandlerMethod handlerMethod, DocumentationEndPoint endPoint, Collection<RequestMethod> methods, ParamsRequestCondition paramsCondition) {
        for (RequestMethod requestMethod : methods) {
            endPoint.addOperation(this.operationReader.readOperation(controllerDocumentation, handlerMethod, paramsCondition, requestMethod));
        }
    }

    public ControllerDocumentation getDocumentation(String apiName) {
        this.ensureDocumentationReady();
        for (ControllerDocumentation documentation : this.resourceDocumentationLookup.values()) {
            if (!documentation.matchesName(apiName).booleanValue()) continue;
            return documentation;
        }
        log.error("Could not find a matching resource for api with name '" + apiName + "'");
        return null;
    }

    public Documentation getDocumentation() {
        this.ensureDocumentationReady();
        return this.documentation;
    }

    private void ensureDocumentationReady() {
        if (!this.isMappingBuilt) {
            this.buildMappingDocuments(this.context);
        }
    }

    public List<RequestMappingHandlerMapping> getHandlerMappings() {
        return this.handlerMappings;
    }
}

