/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mangofactory.swagger.models.DocumentationSchemaProvider;
import com.mangofactory.swagger.models.Model;
import com.mangofactory.swagger.models.Models;
import com.wordnik.swagger.core.Documentation;
import com.wordnik.swagger.core.DocumentationEndPoint;
import com.wordnik.swagger.core.DocumentationOperation;
import com.wordnik.swagger.core.DocumentationSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMethod;

@XmlRootElement
public class ControllerDocumentation
extends Documentation {
    private static final Logger log = LoggerFactory.getLogger(ControllerDocumentation.class);
    private final List<DocumentationEndPoint> endpoints = Lists.newArrayList();
    private final Map<String, Model> modelMap = Maps.newHashMap();
    private DocumentationSchemaProvider schemaProvider;
    private HashMap<String, DocumentationSchema> models;

    ControllerDocumentation() {
    }

    public ControllerDocumentation(String apiVersion, String swaggerVersion, String basePath, String resourceUri, DocumentationSchemaProvider schemaProvider) {
        super(apiVersion, swaggerVersion, basePath, resourceUri);
        this.schemaProvider = schemaProvider;
    }

    public void addEndpoint(DocumentationEndPoint endpoint) {
        this.endpoints.add(endpoint);
    }

    public void putModel(String name, Model model) {
        this.modelMap.put(name, model);
    }

    public Boolean matchesName(String name) {
        String nameWithForwardSlash = name.startsWith("/") ? name : "/" + name;
        String nameWithoutForwardSlash = name.startsWith("/") ? name.substring(1) : name;
        return this.getResourcePath().equals(nameWithoutForwardSlash) || this.getResourcePath().equals(nameWithForwardSlash);
    }

    public List<DocumentationOperation> getEndPoint(String requestUri, RequestMethod method) {
        ArrayList operations = Lists.newArrayList();
        for (DocumentationEndPoint endPoint : this.endpoints) {
            if (!StringUtils.equals((String)endPoint.getPath(), (String)requestUri)) continue;
            for (DocumentationOperation operation : endPoint.getOperations()) {
                if (!operation.getHttpMethod().equals(method.name())) continue;
                operations.add(operation);
            }
        }
        return operations;
    }

    public List<DocumentationEndPoint> getApis() {
        return this.endpoints;
    }

    public HashMap<String, DocumentationSchema> getModels() {
        if (this.models == null) {
            this.models = Maps.newHashMap();
            for (Model model : this.modelMap.values()) {
                this.models.putAll((Map)Models.Fn.modelToSchema(this.schemaProvider).apply((Object)model));
            }
            this.modelMap.clear();
        }
        return this.models;
    }
}

