/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger;

import com.google.common.annotations.VisibleForTesting;
import com.mangofactory.swagger.EndpointComparator;
import com.mangofactory.swagger.OperationComparator;
import com.wordnik.swagger.core.Documentation;
import com.wordnik.swagger.core.DocumentationEndPoint;
import com.wordnik.swagger.core.DocumentationOperation;
import java.util.Collections;
import java.util.Comparator;

public abstract class DocumentationTransformer {
    private Comparator<DocumentationEndPoint> endPointComparator;
    private Comparator<DocumentationOperation> operationComparator;

    public DocumentationTransformer(EndpointComparator endPointComparator, OperationComparator operationComparator) {
        this.endPointComparator = endPointComparator;
        this.operationComparator = operationComparator;
    }

    public Documentation applySorting(Documentation transformed) {
        if (this.endPointComparator != null && transformed.getApis() != null) {
            Collections.sort(transformed.getApis(), this.endPointComparator);
            for (DocumentationEndPoint endpoint : transformed.getApis()) {
                if (this.operationComparator == null || endpoint.getOperations() == null) continue;
                Collections.sort(endpoint.getOperations(), this.operationComparator);
            }
        }
        return transformed;
    }

    public abstract Documentation applyTransformation(Documentation var1);

    @VisibleForTesting
    void setEndPointComparator(Comparator<DocumentationEndPoint> endPointComparator) {
        this.endPointComparator = endPointComparator;
    }

    @VisibleForTesting
    void setOperationComparator(Comparator<DocumentationOperation> operationComparator) {
        this.operationComparator = operationComparator;
    }
}

