/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models;

import com.fasterxml.classmate.MemberResolver;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mangofactory.swagger.AliasedResolvedField;
import com.mangofactory.swagger.models.ResolvedProperty;
import com.mangofactory.swagger.models.ResolvedTypes;
import com.mangofactory.swagger.models.SchemaDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class Jackson2SchemaDescriptor
implements SchemaDescriptor {
    private final ObjectMapper objectMapper;

    @Autowired
    public Jackson2SchemaDescriptor(@Qualifier(value="documentationObjectMapper") ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public List<AliasedResolvedField> serializableFields(TypeResolver typeResolver, ResolvedType resolvedType) {
        ArrayList serializationCandidates = Lists.newArrayList();
        MemberResolver memberResolver = new MemberResolver(typeResolver);
        ResolvedTypeWithMembers resolvedMemberWithMembers = memberResolver.resolve(resolvedType, null, null);
        SerializationConfig serializationConfig = this.objectMapper.getSerializationConfig();
        BeanDescription beanDescription = serializationConfig.introspect(TypeFactory.defaultInstance().constructType((Type)resolvedType.getErasedType()));
        ImmutableMap propertyLookup = Maps.uniqueIndex((Iterable)beanDescription.findProperties(), this.beanPropertyByInternalName());
        for (ResolvedField childField : resolvedMemberWithMembers.getMemberFields()) {
            BeanPropertyDefinition propertyDefinition;
            AnnotatedMember member;
            if (!propertyLookup.containsKey(childField.getName()) || (member = (propertyDefinition = (BeanPropertyDefinition)propertyLookup.get(childField.getName())).getPrimaryMember()) == null || member.getMember() == null || !Field.class.isAssignableFrom(member.getMember().getClass())) continue;
            serializationCandidates.add(new AliasedResolvedField(propertyDefinition.getName(), childField));
        }
        return serializationCandidates;
    }

    @Override
    public List<AliasedResolvedField> deserializableFields(TypeResolver typeResolver, ResolvedType resolvedType) {
        ArrayList serializationCandidates = Lists.newArrayList();
        MemberResolver memberResolver = new MemberResolver(typeResolver);
        ResolvedTypeWithMembers resolvedMemberWithMembers = memberResolver.resolve(resolvedType, null, null);
        DeserializationConfig serializationConfig = this.objectMapper.getDeserializationConfig();
        BeanDescription beanDescription = serializationConfig.introspect(TypeFactory.defaultInstance().constructType((Type)resolvedType.getErasedType()));
        ImmutableMap propertyLookup = Maps.uniqueIndex((Iterable)beanDescription.findProperties(), this.beanPropertyByInternalName());
        for (ResolvedField childField : resolvedMemberWithMembers.getMemberFields()) {
            BeanPropertyDefinition propertyDefinition;
            AnnotatedMember member;
            if (!propertyLookup.containsKey(childField.getName()) || (member = (propertyDefinition = (BeanPropertyDefinition)propertyLookup.get(childField.getName())).getPrimaryMember()) == null || member.getMember() == null || !Field.class.isAssignableFrom(member.getMember().getClass())) continue;
            serializationCandidates.add(new AliasedResolvedField(propertyDefinition.getName(), childField));
        }
        return serializationCandidates;
    }

    @Override
    public List<ResolvedProperty> serializableProperties(TypeResolver typeResolver, ResolvedType resolvedType) {
        ArrayList serializationCandidates = Lists.newArrayList();
        SerializationConfig serializationConfig = this.objectMapper.getSerializationConfig();
        BeanDescription beanDescription = serializationConfig.introspect(TypeFactory.defaultInstance().constructType((Type)resolvedType.getErasedType()));
        ImmutableMap propertyLookup = Maps.uniqueIndex((Iterable)beanDescription.findProperties(), this.beanPropertyByInternalName());
        for (ResolvedProperty childProperty : ResolvedTypes.gettersAndSetters(typeResolver, resolvedType)) {
            BeanPropertyDefinition propertyDefinition;
            AnnotatedMember member;
            if (!propertyLookup.containsKey(childProperty.getName()) || (member = (propertyDefinition = (BeanPropertyDefinition)propertyLookup.get(childProperty.getName())).getPrimaryMember()) == null || member.getMember() == null || !Method.class.isAssignableFrom(member.getMember().getClass()) || !Objects.equal((Object)member.getMember().getName(), (Object)childProperty.getMethodName())) continue;
            childProperty.setName(propertyDefinition.getName());
            serializationCandidates.add(childProperty);
        }
        return serializationCandidates;
    }

    @Override
    public List<ResolvedProperty> deserializableProperties(TypeResolver typeResolver, ResolvedType resolvedType) {
        ArrayList serializationCandidates = Lists.newArrayList();
        DeserializationConfig serializationConfig = this.objectMapper.getDeserializationConfig();
        BeanDescription beanDescription = serializationConfig.introspect(TypeFactory.defaultInstance().constructType((Type)resolvedType.getErasedType()));
        ImmutableMap propertyLookup = Maps.uniqueIndex((Iterable)beanDescription.findProperties(), this.beanPropertyByInternalName());
        for (ResolvedProperty childProperty : ResolvedTypes.gettersAndSetters(typeResolver, resolvedType)) {
            BeanPropertyDefinition propertyDefinition;
            AnnotatedMember member;
            if (!propertyLookup.containsKey(childProperty.getName()) || (member = (propertyDefinition = (BeanPropertyDefinition)propertyLookup.get(childProperty.getName())).getPrimaryMember()) == null || member.getMember() == null || !Method.class.isAssignableFrom(member.getMember().getClass()) || !Objects.equal((Object)member.getMember().getName(), (Object)childProperty.getMethodName())) continue;
            childProperty.setName(propertyDefinition.getName());
            serializationCandidates.add(childProperty);
        }
        return serializationCandidates;
    }

    private Function<BeanPropertyDefinition, String> beanPropertyByName() {
        return new Function<BeanPropertyDefinition, String>(){

            public String apply(BeanPropertyDefinition input) {
                return input.getName();
            }
        };
    }

    private Function<BeanPropertyDefinition, String> beanPropertyByInternalName() {
        return new Function<BeanPropertyDefinition, String>(){

            public String apply(BeanPropertyDefinition input) {
                return input.getInternalName();
            }
        };
    }
}

