/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.types.ResolvedArrayType;
import com.fasterxml.classmate.types.ResolvedInterfaceType;
import com.fasterxml.classmate.types.ResolvedObjectType;
import com.fasterxml.classmate.types.ResolvedPrimitiveType;
import com.fasterxml.classmate.types.ResolvedRecursiveType;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mangofactory.swagger.AliasedResolvedField;
import com.mangofactory.swagger.models.DateMemberVisitor;
import com.mangofactory.swagger.models.MemberVisitor;
import com.mangofactory.swagger.models.ObjectMemberVisitor;
import com.mangofactory.swagger.models.PrimitiveMemberVisitor;
import com.mangofactory.swagger.models.ResolvedArrayMemberVisitor;
import com.mangofactory.swagger.models.ResolvedFieldInfo;
import com.mangofactory.swagger.models.ResolvedProperty;
import com.mangofactory.swagger.models.ResolvedTypeMemberSource;
import com.mangofactory.swagger.models.ResolvedTypeMemberVisitor;
import com.mangofactory.swagger.models.SchemaDescriptor;
import com.wordnik.swagger.core.DocumentationSchema;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SchemaProvider {
    private static final Map<Class, Function<SchemaProvider, MemberVisitor>> propertySchemas = ImmutableMap.builder().put(Double.TYPE, PrimitiveMemberVisitor.factory()).put(Double.class, PrimitiveMemberVisitor.factory()).put(Integer.TYPE, PrimitiveMemberVisitor.factory()).put(Integer.class, PrimitiveMemberVisitor.factory()).put(Long.TYPE, PrimitiveMemberVisitor.factory()).put(Long.class, PrimitiveMemberVisitor.factory()).put(Short.TYPE, PrimitiveMemberVisitor.factory()).put(Short.class, PrimitiveMemberVisitor.factory()).put(Byte.TYPE, PrimitiveMemberVisitor.factory()).put(Byte.class, PrimitiveMemberVisitor.factory()).put(Boolean.TYPE, PrimitiveMemberVisitor.factory()).put(Boolean.class, PrimitiveMemberVisitor.factory()).put(Float.TYPE, PrimitiveMemberVisitor.factory()).put(Float.class, PrimitiveMemberVisitor.factory()).put(String.class, PrimitiveMemberVisitor.factory()).put(Date.class, DateMemberVisitor.factory()).put(Object.class, ObjectMemberVisitor.factory()).put(ResolvedProperty.class, ResolvedTypeMemberVisitor.factory()).put(ResolvedObjectType.class, ResolvedTypeMemberVisitor.factory()).put(ResolvedPrimitiveType.class, ResolvedTypeMemberVisitor.factory()).put(ResolvedArrayType.class, ResolvedArrayMemberVisitor.factory()).put(ResolvedRecursiveType.class, ResolvedTypeMemberVisitor.factory()).put(ResolvedInterfaceType.class, ResolvedTypeMemberVisitor.factory()).build();
    private final HashMap<String, DocumentationSchema> schemaMap = Maps.newHashMap();
    private final SchemaDescriptor descriptor;
    private final TypeResolver typeResolver;
    private final boolean returnType;

    public SchemaProvider(SchemaDescriptor descriptor, TypeResolver typeResolver, boolean returnType) {
        this.descriptor = descriptor;
        this.typeResolver = typeResolver;
        this.returnType = returnType;
    }

    public DocumentationSchema schema(ResolvedField field) {
        ResolvedFieldInfo memberInfo = new ResolvedFieldInfo(field);
        return ((MemberVisitor)this.findKey(field).apply((Object)this)).schema(memberInfo);
    }

    public DocumentationSchema schema(ResolvedProperty property) {
        return ((MemberVisitor)this.findKey(property).apply((Object)this)).schema(property);
    }

    public DocumentationSchema schema(ResolvedType resolvedType) {
        ResolvedTypeMemberSource memberSource = new ResolvedTypeMemberSource(resolvedType);
        return ((MemberVisitor)this.findKey((Type)resolvedType).apply((Object)this)).schema(memberSource);
    }

    private Function<SchemaProvider, MemberVisitor> findKey(Type returnType) {
        if (propertySchemas.containsKey(returnType.getClass())) {
            return propertySchemas.get(returnType.getClass());
        }
        throw new UnsupportedOperationException();
    }

    private Function<SchemaProvider, MemberVisitor> findKey(ResolvedField field) {
        if (propertySchemas.containsKey(field.getType().getClass())) {
            return propertySchemas.get(field.getType().getClass());
        }
        return propertySchemas.get(field.getType().getClass());
    }

    private Function<SchemaProvider, MemberVisitor> findKey(ResolvedProperty property) {
        if (property.getResolvedType().isPrimitive() || propertySchemas.containsKey(property.getType())) {
            return propertySchemas.get(property.getType());
        }
        return propertySchemas.get(property.getResolvedType().getClass());
    }

    public HashMap<String, DocumentationSchema> getSchemaMap() {
        return this.schemaMap;
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public boolean isReturnType() {
        return this.returnType;
    }

    public List<AliasedResolvedField> getResolvedFields(ResolvedType resolvedType) {
        if (this.isReturnType()) {
            return this.descriptor.serializableFields(this.getTypeResolver(), resolvedType);
        }
        return this.descriptor.deserializableFields(this.getTypeResolver(), resolvedType);
    }

    public List<ResolvedProperty> getResolvedProperties(ResolvedType resolvedType) {
        if (this.isReturnType()) {
            return this.descriptor.serializableProperties(this.getTypeResolver(), resolvedType);
        }
        return this.descriptor.deserializableProperties(this.getTypeResolver(), resolvedType);
    }

    public DocumentationSchema generateCustomSchema(ResolvedType resolvedType) {
        return ((MemberVisitor)this.findKey(resolvedType.getErasedType()).apply((Object)this)).schema(new ResolvedTypeMemberSource(resolvedType));
    }
}

