/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.spring.filters;

import com.mangofactory.swagger.annotations.ApiError;
import com.mangofactory.swagger.annotations.ApiErrors;
import com.mangofactory.swagger.filters.Filter;
import com.mangofactory.swagger.filters.FilterContext;
import com.wordnik.swagger.core.DocumentationError;
import java.util.List;
import org.springframework.web.method.HandlerMethod;

public class ErrorsFilter
implements Filter<List<DocumentationError>> {
    @Override
    public void apply(FilterContext<List<DocumentationError>> context) {
        List<DocumentationError> errors = context.subject();
        HandlerMethod handlerMethod = (HandlerMethod)context.get("handlerMethod");
        this.documentExceptions(errors, handlerMethod);
    }

    private void documentExceptions(List<DocumentationError> errors, HandlerMethod handlerMethod) {
        this.discoverSpringMvcExceptions(errors, handlerMethod);
        this.discoverThrowsExceptions(errors, handlerMethod);
    }

    private void discoverThrowsExceptions(List<DocumentationError> error, HandlerMethod handlerMethod) {
        Class<?>[] exceptionTypes;
        for (Class<?> exceptionType : exceptionTypes = handlerMethod.getMethod().getExceptionTypes()) {
            this.appendErrorFromClass(error, exceptionType);
        }
    }

    private void discoverSpringMvcExceptions(List<DocumentationError> errors, HandlerMethod handlerMethod) {
        ApiErrors apiErrors = (ApiErrors)handlerMethod.getMethodAnnotation(ApiErrors.class);
        if (apiErrors == null) {
            return;
        }
        for (Class<? extends Throwable> exceptionClass : apiErrors.value()) {
            this.appendErrorFromClass(errors, exceptionClass);
        }
        for (ApiError apiError : apiErrors.errors()) {
            errors.add(new DocumentationError(apiError.code(), apiError.reason()));
        }
    }

    void appendErrorFromClass(List<DocumentationError> errors, Class<? extends Throwable> exceptionClass) {
        ApiError apiError = exceptionClass.getAnnotation(ApiError.class);
        if (apiError == null) {
            return;
        }
        errors.add(new DocumentationError(apiError.code(), apiError.reason()));
    }
}

