/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.spring.filters;

import com.fasterxml.classmate.ResolvedType;
import com.mangofactory.swagger.ControllerDocumentation;
import com.mangofactory.swagger.SwaggerConfiguration;
import com.mangofactory.swagger.filters.Filter;
import com.mangofactory.swagger.filters.FilterContext;
import com.mangofactory.swagger.models.Models;
import com.mangofactory.swagger.models.ResolvedTypes;
import com.mangofactory.swagger.spring.Descriptions;
import com.wordnik.swagger.core.DocumentationOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;

public class OperationFilter
implements Filter<DocumentationOperation> {
    private static final Logger log = LoggerFactory.getLogger(OperationFilter.class);

    @Override
    public void apply(FilterContext<DocumentationOperation> context) {
        DocumentationOperation operation = context.subject();
        HandlerMethod handlerMethod = (HandlerMethod)context.get("handlerMethod");
        ControllerDocumentation controllerDocumentation = (ControllerDocumentation)((Object)context.get("controllerDocumentation"));
        SwaggerConfiguration configuration = (SwaggerConfiguration)context.get("swaggerConfiguration");
        this.documentOperation(configuration, controllerDocumentation, operation, handlerMethod);
    }

    private void documentOperation(SwaggerConfiguration configuration, ControllerDocumentation controllerDocumentation, DocumentationOperation operation, HandlerMethod handlerMethod) {
        operation.setSummary(Descriptions.splitCamelCase(handlerMethod.getMethod().getName()));
        operation.setNotes("");
        operation.setNickname(handlerMethod.getMethod().getName());
        operation.setDeprecated(Boolean.valueOf(handlerMethod.getMethodAnnotation(Deprecated.class) != null));
        ResolvedType parameterType = ResolvedTypes.methodReturnType(configuration.getTypeResolver(), handlerMethod.getMethod());
        if (parameterType != null) {
            ResolvedType alternateType = configuration.maybeGetAlternateType(parameterType);
            if (configuration.isParameterTypeIgnorable(alternateType)) {
                return;
            }
            operation.setResponseClass(ResolvedTypes.modelName(alternateType));
            Models.maybeAddParameterTypeToModels(controllerDocumentation, alternateType, ResolvedTypes.modelName(alternateType), true);
        }
    }
}

