/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.core;

import com.mangofactory.swagger.ScalaUtils;
import com.mangofactory.swagger.authorization.AuthorizationContext;
import com.mangofactory.swagger.configuration.SwaggerGlobalSettings;
import com.mangofactory.swagger.core.SwaggerCache;
import com.mangofactory.swagger.core.SwaggerPathProvider;
import com.mangofactory.swagger.scanners.ApiListingReferenceScanner;
import com.mangofactory.swagger.scanners.ApiListingScanner;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import com.wordnik.swagger.core.SwaggerSpec;
import com.wordnik.swagger.model.ApiInfo;
import com.wordnik.swagger.model.ApiListing;
import com.wordnik.swagger.model.AuthorizationType;
import com.wordnik.swagger.model.ResourceListing;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerApiResourceListing {
    private static final Logger log = LoggerFactory.getLogger(SwaggerApiResourceListing.class);
    private SwaggerCache swaggerCache;
    private ApiInfo apiInfo;
    private List<AuthorizationType> authorizationTypes;
    private AuthorizationContext authorizationContext;
    private ApiListingReferenceScanner apiListingReferenceScanner;
    private SwaggerPathProvider swaggerPathProvider;
    private SwaggerGlobalSettings swaggerGlobalSettings;
    private String swaggerGroup;

    public SwaggerApiResourceListing(SwaggerCache swaggerCache, String swaggerGroup) {
        this.swaggerCache = swaggerCache;
        this.swaggerGroup = swaggerGroup;
    }

    @PostConstruct
    public void initialize() {
        List<Object> apiListingReferences = new ArrayList();
        if (null != this.apiListingReferenceScanner) {
            this.apiListingReferenceScanner.scan();
            apiListingReferences = this.apiListingReferenceScanner.getApiListingReferences();
            Map<String, List<RequestMappingContext>> resourceGroupRequestMappings = this.apiListingReferenceScanner.getResourceGroupRequestMappings();
            ApiListingScanner apiListingScanner = new ApiListingScanner(resourceGroupRequestMappings, this.apiListingReferenceScanner.getSwaggerGroup(), this.swaggerPathProvider, this.authorizationContext);
            apiListingScanner.setSwaggerGlobalSettings(this.swaggerGlobalSettings);
            Map<String, ApiListing> apiListings = apiListingScanner.scan();
            this.swaggerCache.addApiListings(this.swaggerGroup, apiListings);
        } else {
            log.error("ApiListingReferenceScanner not configured");
        }
        ResourceListing resourceListing = new ResourceListing("1", SwaggerSpec.version(), ScalaUtils.toScalaList(apiListingReferences), ScalaUtils.toScalaList(this.authorizationTypes), ScalaUtils.toOption(this.apiInfo));
        this.swaggerCache.addSwaggerResourceListing(this.swaggerGroup, resourceListing);
    }

    public SwaggerCache getSwaggerCache() {
        return this.swaggerCache;
    }

    public void setSwaggerCache(SwaggerCache swaggerCache) {
        this.swaggerCache = swaggerCache;
    }

    public ApiInfo getApiInfo() {
        return this.apiInfo;
    }

    public void setApiInfo(ApiInfo apiInfo) {
        this.apiInfo = apiInfo;
    }

    public List<AuthorizationType> getAuthorizationTypes() {
        return this.authorizationTypes;
    }

    public void setAuthorizationTypes(List<AuthorizationType> authorizationTypes) {
        this.authorizationTypes = authorizationTypes;
    }

    public ApiListingReferenceScanner getApiListingReferenceScanner() {
        return this.apiListingReferenceScanner;
    }

    public void setApiListingReferenceScanner(ApiListingReferenceScanner apiListingReferenceScanner) {
        this.apiListingReferenceScanner = apiListingReferenceScanner;
    }

    public SwaggerPathProvider getSwaggerPathProvider() {
        return this.swaggerPathProvider;
    }

    public void setSwaggerPathProvider(SwaggerPathProvider swaggerPathProvider) {
        this.swaggerPathProvider = swaggerPathProvider;
    }

    public SwaggerGlobalSettings getSwaggerGlobalSettings() {
        return this.swaggerGlobalSettings;
    }

    public void setSwaggerGlobalSettings(SwaggerGlobalSettings swaggerGlobalSettings) {
        this.swaggerGlobalSettings = swaggerGlobalSettings;
    }

    public String getSwaggerGroup() {
        return this.swaggerGroup;
    }

    public void setSwaggerGroup(String swaggerGroup) {
        this.swaggerGroup = swaggerGroup;
    }

    public void setAuthorizationContext(AuthorizationContext authorizationContext) {
        this.authorizationContext = authorizationContext;
    }
}

