/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers;

import com.google.common.collect.Maps;
import com.mangofactory.swagger.ScalaUtils;
import com.mangofactory.swagger.readers.Command;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.converter.SwaggerSchemaConverter;
import com.wordnik.swagger.model.Model;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import scala.Option;
import scala.collection.immutable.Map;

public class ApiModelReader
implements Command<RequestMappingContext> {
    private static final Logger log = LoggerFactory.getLogger(ApiModelReader.class);

    @Override
    public void execute(RequestMappingContext context) {
        HandlerMethod handlerMethod = context.getHandlerMethod();
        log.debug("Reading models for handlerMethod |{}|", (Object)handlerMethod.getMethod().getName());
        SwaggerSchemaConverter parser = new SwaggerSchemaConverter();
        HashMap modelMap = Maps.newHashMap();
        Class modelType = handlerMethod.getMethod().getReturnType();
        ApiOperation apiOperationAnnotation = (ApiOperation)handlerMethod.getMethodAnnotation(ApiOperation.class);
        if (null != apiOperationAnnotation && Void.class != apiOperationAnnotation.response()) {
            modelType = apiOperationAnnotation.response();
        }
        String schemaName = modelType.isArray() ? modelType.getComponentType().getSimpleName() : modelType.getSimpleName();
        Option sModel = parser.read(modelType, (Map)new scala.collection.immutable.HashMap());
        Model model = (Model)ScalaUtils.fromOption(sModel);
        if (null != model) {
            log.debug("Swagger generated model {} models", (Object)model.id());
            modelMap.put(schemaName, model);
        } else {
            log.debug("Swagger core did not find any models");
        }
        log.debug("Finished reading models for handlerMethod |{}|", (Object)handlerMethod.getMethod().getName());
        context.put("models", modelMap);
    }
}

