/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers.operation;

import com.google.common.collect.Lists;
import com.mangofactory.swagger.ScalaUtils;
import com.mangofactory.swagger.configuration.SwaggerGlobalSettings;
import com.mangofactory.swagger.core.CommandExecutor;
import com.mangofactory.swagger.readers.Command;
import com.mangofactory.swagger.readers.operation.parameter.ParameterAllowableReader;
import com.mangofactory.swagger.readers.operation.parameter.ParameterDataTypeReader;
import com.mangofactory.swagger.readers.operation.parameter.ParameterDefaultReader;
import com.mangofactory.swagger.readers.operation.parameter.ParameterDescriptionReader;
import com.mangofactory.swagger.readers.operation.parameter.ParameterMultiplesReader;
import com.mangofactory.swagger.readers.operation.parameter.ParameterNameReader;
import com.mangofactory.swagger.readers.operation.parameter.ParameterRequiredReader;
import com.mangofactory.swagger.readers.operation.parameter.ParameterTypeReader;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import com.wordnik.swagger.model.AllowableValues;
import com.wordnik.swagger.model.Parameter;
import java.util.ArrayList;
import java.util.Set;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.web.method.HandlerMethod;

public class OperationParameterReader
implements Command<RequestMappingContext> {
    @Override
    public void execute(RequestMappingContext context) {
        HandlerMethod handlerMethod = context.getHandlerMethod();
        SwaggerGlobalSettings swaggerGlobalSettings = (SwaggerGlobalSettings)context.get("swaggerGlobalSettings");
        MethodParameter[] methodParameters = handlerMethod.getMethodParameters();
        ArrayList parameters = Lists.newArrayList();
        for (MethodParameter methodParameter : methodParameters) {
            Class parameterType = methodParameter.getParameterType();
            if (this.shouldIgnore(parameterType, swaggerGlobalSettings.getIgnorableParameterTypes())) continue;
            RequestMappingContext parameterContext = new RequestMappingContext(context.getRequestMappingInfo(), handlerMethod);
            methodParameter.initParameterNameDiscovery((ParameterNameDiscoverer)new LocalVariableTableParameterNameDiscoverer());
            parameterContext.put("methodParameter", methodParameter);
            parameterContext.put("swaggerGlobalSettings", swaggerGlobalSettings);
            CommandExecutor commandExecutor = new CommandExecutor();
            ArrayList commandList = Lists.newArrayList();
            commandList.add(new ParameterAllowableReader());
            commandList.add(new ParameterDataTypeReader());
            commandList.add(new ParameterTypeReader());
            commandList.add(new ParameterDefaultReader());
            commandList.add(new ParameterDescriptionReader());
            commandList.add(new ParameterMultiplesReader());
            commandList.add(new ParameterNameReader());
            commandList.add(new ParameterRequiredReader());
            commandExecutor.execute(commandList, parameterContext);
            Object result = parameterContext.getResult();
            Parameter parameter = new Parameter((String)result.get("name"), ScalaUtils.toOption(result.get("description")), ScalaUtils.toOption(result.get("defaultValue")), ((Boolean)result.get("required")).booleanValue(), ((Boolean)result.get("allowMultiple")).booleanValue(), (String)result.get("dataType"), (AllowableValues)result.get("allowableValues"), (String)result.get("paramType"), ScalaUtils.toOption(result.get("paramAccess")));
            parameters.add(parameter);
        }
        context.put("parameters", parameters);
    }

    private boolean shouldIgnore(Class paramType, Set<Class> ignorableParamTypes) {
        return null != ignorableParamTypes && !ignorableParamTypes.isEmpty() && ignorableParamTypes.contains(paramType);
    }
}

