/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers.operation;

import com.mangofactory.swagger.ScalaUtils;
import com.mangofactory.swagger.configuration.SwaggerGlobalSettings;
import com.mangofactory.swagger.core.ModelUtils;
import com.mangofactory.swagger.readers.Command;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import com.wordnik.swagger.model.ResponseMessage;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;

public class OperationResponseMessageReader
implements Command<RequestMappingContext> {
    @Override
    public void execute(RequestMappingContext context) {
        SwaggerGlobalSettings swaggerGlobalSettings = (SwaggerGlobalSettings)context.get("swaggerGlobalSettings");
        RequestMethod currentHttpMethod = (RequestMethod)context.get("currentHttpMethod");
        HandlerMethod handlerMethod = context.getHandlerMethod();
        ArrayList<ResponseMessage> responseMessages = new ArrayList();
        ApiResponses apiResponses = this.getAnnotatedResponseMessages(handlerMethod.getMethod());
        if (null != apiResponses) {
            ApiResponse[] apiResponseAnnotations;
            for (ApiResponse apiResponse : apiResponseAnnotations = apiResponses.value()) {
                responseMessages.add(new ResponseMessage(apiResponse.code(), apiResponse.message(), ScalaUtils.toOption(null)));
            }
        } else {
            Class<?> returnType;
            Map<RequestMethod, List<ResponseMessage>> globalResponseMessages = swaggerGlobalSettings.getGlobalResponseMessages();
            if (null != globalResponseMessages) {
                responseMessages = globalResponseMessages.get(currentHttpMethod);
            }
            if (Void.class != (returnType = ModelUtils.getHandlerReturnType(handlerMethod))) {
                String simpleName = returnType.getSimpleName();
                ResponseMessage responseWithModel = new ResponseMessage(200, HttpStatus.OK.getReasonPhrase(), ScalaUtils.toOption(simpleName));
                this.safelyRemoveHttpOkResponse(responseMessages);
                responseMessages.add(responseWithModel);
            }
        }
        context.put("responseMessages", responseMessages);
    }

    private ApiResponses getAnnotatedResponseMessages(Method method) {
        Annotation[] methodAnnotations = method.getAnnotations();
        if (null != methodAnnotations) {
            for (Annotation annotation : methodAnnotations) {
                if (!(annotation instanceof ApiResponses)) continue;
                return (ApiResponses)annotation;
            }
        }
        return null;
    }

    private void safelyRemoveHttpOkResponse(List<ResponseMessage> responseMessages) {
        if (null != responseMessages && responseMessages.size() > 0) {
            Iterator<ResponseMessage> i = responseMessages.iterator();
            while (i.hasNext()) {
                ResponseMessage msg = i.next();
                if (msg.code() != 200) continue;
                i.remove();
                break;
            }
        }
    }
}

