/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.controllers;

import com.mangofactory.swagger.annotations.ApiIgnore;
import com.mangofactory.swagger.core.SwaggerCache;
import com.wordnik.swagger.model.ApiListing;
import com.wordnik.swagger.model.ResourceListing;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DefaultSwaggerController {
    public static final String DOCUMENTATION_BASE_PATH = "/api-docs";
    @Autowired
    private SwaggerCache swaggerCache;

    @ApiIgnore
    @RequestMapping(value={"/api-docs"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<ResourceListing> getResourceListingByKey() {
        return this.getSwaggerResourceListing(null);
    }

    @ApiIgnore
    @RequestMapping(value={"/api-docs/{resourceKey}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<ResourceListing> getResourceListing(@PathVariable String resourceKey) {
        return this.getSwaggerResourceListing(resourceKey);
    }

    @ApiIgnore
    @RequestMapping(value={"/api-docs/{resourceKey}/{resource}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<ApiListing> getApiListing(@PathVariable String resourceKey, @PathVariable String resource) {
        return this.getSwaggerApiListing(resourceKey, resource);
    }

    private ResponseEntity<ApiListing> getSwaggerApiListing(String resourceKey, String resource) {
        ApiListing apiListing;
        ResponseEntity responseEntity = new ResponseEntity(HttpStatus.NOT_FOUND);
        Map<String, ApiListing> apiListingMap = this.swaggerCache.getSwaggerApiListingMap().get(resourceKey);
        if (null != apiListingMap && null != (apiListing = apiListingMap.get(resource))) {
            responseEntity = new ResponseEntity((Object)apiListing, HttpStatus.OK);
        }
        return responseEntity;
    }

    private ResponseEntity<ResourceListing> getSwaggerResourceListing(String resourceKey) {
        ResponseEntity responseEntity = new ResponseEntity(HttpStatus.NOT_FOUND);
        ResourceListing resourceListing = null;
        if (null == resourceKey) {
            resourceListing = this.swaggerCache.getSwaggerApiResourceListingMap().values().iterator().next();
        } else if (this.swaggerCache.getSwaggerApiResourceListingMap().containsKey(resourceKey)) {
            resourceListing = this.swaggerCache.getSwaggerApiResourceListingMap().get(resourceKey);
        }
        if (null != resourceListing) {
            responseEntity = new ResponseEntity((Object)resourceListing, HttpStatus.OK);
        }
        return responseEntity;
    }
}

