/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers;

import com.google.common.collect.Maps;
import com.mangofactory.swagger.ScalaUtils;
import com.mangofactory.swagger.readers.Command;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.converter.SwaggerSchemaConverter;
import com.wordnik.swagger.model.Model;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.method.HandlerMethod;
import scala.Option;

public class ApiModelReader
implements Command<RequestMappingContext> {
    private static final Logger log = LoggerFactory.getLogger(ApiModelReader.class);
    private SwaggerSchemaConverter parser = new SwaggerSchemaConverter();

    @Override
    public void execute(RequestMappingContext context) {
        HandlerMethod handlerMethod = context.getHandlerMethod();
        log.debug("Reading models for handlerMethod |{}|", (Object)handlerMethod.getMethod().getName());
        HashMap modelMap = Maps.newHashMap();
        Class modelType = handlerMethod.getMethod().getReturnType();
        ApiOperation apiOperationAnnotation = (ApiOperation)handlerMethod.getMethodAnnotation(ApiOperation.class);
        if (null != apiOperationAnnotation && Void.class != apiOperationAnnotation.response()) {
            modelType = apiOperationAnnotation.response();
        }
        String schemaName = modelType.isArray() ? modelType.getComponentType().getSimpleName() : modelType.getSimpleName();
        Option sModel = this.parser.read(modelType, (scala.collection.immutable.Map)new scala.collection.immutable.HashMap());
        Model model = (Model)ScalaUtils.fromOption(sModel);
        if (null != model) {
            log.debug("Swagger generated model {} models", (Object)model.id());
            modelMap.put(schemaName, model);
        } else {
            log.debug("Swagger core did not find any models");
        }
        modelMap.putAll(this.readParametersApiModel(handlerMethod));
        log.debug("Finished reading models for handlerMethod |{}|", (Object)handlerMethod.getMethod().getName());
        context.put("models", modelMap);
    }

    private Map<String, Model> readParametersApiModel(HandlerMethod handlerMethod) {
        Method method = handlerMethod.getMethod();
        HashMap modelMap = Maps.newHashMap();
        log.debug("Reading parameters models for handlerMethod |{}|", (Object)handlerMethod.getMethod().getName());
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            Annotation[] pAnnotations;
            for (Annotation annotation : pAnnotations = annotations[i]) {
                if (!(annotation instanceof RequestBody)) continue;
                Class<?> pType = parameterTypes[i];
                String pSchemaName = pType.isArray() ? pType.getComponentType().getSimpleName() : pType.getSimpleName();
                Option spModel = this.parser.read(pType, (scala.collection.immutable.Map)new scala.collection.immutable.HashMap());
                Model pModel = (Model)ScalaUtils.fromOption(spModel);
                if (null != pModel) {
                    log.debug("Swagger generated parameter model {} models", (Object)pModel.id());
                    modelMap.put(pSchemaName, pModel);
                    continue;
                }
                log.debug("Swagger core did not find any parameter models for {}", (Object)pSchemaName);
            }
        }
        log.debug("Finished reading parameters models for handlerMethod |{}|", (Object)handlerMethod.getMethod().getName());
        return modelMap;
    }
}

