/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers.operation.parameter;

import com.mangofactory.swagger.readers.Command;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import java.lang.annotation.Annotation;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

public class ParameterTypeReader
implements Command<RequestMappingContext> {
    @Override
    public void execute(RequestMappingContext context) {
        MethodParameter methodParameter = (MethodParameter)context.get("methodParameter");
        context.put("paramType", this.findParameterType(methodParameter));
    }

    private String findParameterType(MethodParameter methodParameter) {
        Annotation[] methodAnnotations = methodParameter.getParameterAnnotations();
        if (null != methodAnnotations) {
            for (Annotation annotation : methodAnnotations) {
                if (annotation instanceof PathVariable) {
                    return "path";
                }
                if (annotation instanceof ModelAttribute) {
                    return "body";
                }
                if (annotation instanceof RequestBody) {
                    return "body";
                }
                if (annotation instanceof RequestParam) {
                    return "query";
                }
                if (!(annotation instanceof RequestHeader)) continue;
                return "header";
            }
        }
        return "body";
    }
}

