/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.configuration;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.scala.DefaultScalaModule;
import com.mangofactory.swagger.configuration.SwaggerApiListingJsonSerializer;
import com.mangofactory.swagger.configuration.SwaggerResourceListingJsonSerializer;
import com.wordnik.swagger.model.ApiListing;
import com.wordnik.swagger.model.ResourceListing;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

public class JacksonScalaSupport {
    private Boolean registerScalaModule = false;
    private RequestMappingHandlerAdapter requestMappingHandlerAdapter;

    @PostConstruct
    public void init() {
        if (this.registerScalaModule.booleanValue()) {
            List messageConverters = this.requestMappingHandlerAdapter.getMessageConverters();
            for (HttpMessageConverter messageConverter : messageConverters) {
                if (!(messageConverter instanceof MappingJackson2HttpMessageConverter)) continue;
                MappingJackson2HttpMessageConverter m = (MappingJackson2HttpMessageConverter)messageConverter;
                m.getObjectMapper().registerModule((Module)new DefaultScalaModule());
                m.getObjectMapper().registerModule(this.swaggerSerializationModule());
            }
        }
    }

    @Autowired
    public void setRequestMappingHandlerAdapter(RequestMappingHandlerAdapter requestMappingHandlerAdapter) {
        this.requestMappingHandlerAdapter = requestMappingHandlerAdapter;
    }

    public Boolean getRegisterScalaModule() {
        return this.registerScalaModule;
    }

    public Module swaggerSerializationModule() {
        SimpleModule module = new SimpleModule("SwaggerAuthorizationTypeModule");
        module.addSerializer(ApiListing.class, (JsonSerializer)new SwaggerApiListingJsonSerializer());
        module.addSerializer(ResourceListing.class, (JsonSerializer)new SwaggerResourceListingJsonSerializer());
        return module;
    }

    public void setRegisterScalaModule(Boolean registerScalaModule) {
        this.registerScalaModule = registerScalaModule;
    }
}

