/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.configuration;

import com.fasterxml.classmate.TypeResolver;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mangofactory.swagger.ScalaUtils;
import com.mangofactory.swagger.annotations.ApiIgnore;
import com.mangofactory.swagger.core.DefaultSwaggerPathProvider;
import com.mangofactory.swagger.core.ResourceGroupingStrategy;
import com.mangofactory.swagger.core.SpringGroupingStrategy;
import com.mangofactory.swagger.core.SwaggerCache;
import com.mangofactory.swagger.core.SwaggerPathProvider;
import com.mangofactory.swagger.models.alternates.AlternateTypeProvider;
import com.mangofactory.swagger.models.alternates.Alternates;
import com.mangofactory.swagger.models.alternates.WildcardType;
import com.wordnik.swagger.model.ResponseMessage;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
@ComponentScan(basePackages={"com.mangofactory.swagger.controllers"})
public class SpringSwaggerConfig {
    @Autowired
    private List<RequestMappingHandlerMapping> handlerMappings;

    @Bean
    public List<RequestMappingHandlerMapping> swaggerRequestMappingHandlerMappings() {
        return this.handlerMappings;
    }

    @Bean
    public ResourceGroupingStrategy defaultResourceGroupingStrategy() {
        return new SpringGroupingStrategy();
    }

    @Bean
    public List<Class<? extends Annotation>> defaultExcludeAnnotations() {
        ArrayList<Class<? extends Annotation>> annotations = new ArrayList<Class<? extends Annotation>>();
        annotations.add(ApiIgnore.class);
        return annotations;
    }

    @Bean
    public SwaggerPathProvider defaultSwaggerPathProvider() {
        return new DefaultSwaggerPathProvider();
    }

    @Bean
    public SwaggerCache swaggerCache() {
        return new SwaggerCache();
    }

    @Bean
    public Set<Class> defaultIgnorableParameterTypes() {
        HashSet ignored = Sets.newHashSet();
        ignored.add(ServletRequest.class);
        ignored.add(HttpHeaders.class);
        ignored.add(ServletResponse.class);
        ignored.add(HttpServletRequest.class);
        ignored.add(HttpServletResponse.class);
        ignored.add(HttpHeaders.class);
        ignored.add(BindingResult.class);
        ignored.add(ServletContext.class);
        ignored.add(UriComponentsBuilder.class);
        return ignored;
    }

    @Bean
    public AlternateTypeProvider defaultAlternateTypeProvider() {
        AlternateTypeProvider alternateTypeProvider = new AlternateTypeProvider();
        TypeResolver typeResolver = new TypeResolver();
        alternateTypeProvider.addRule(Alternates.newRule((Type)typeResolver.resolve(Map.class, new Type[0]), (Type)typeResolver.resolve(Object.class, new Type[0])));
        alternateTypeProvider.addRule(Alternates.newRule((Type)typeResolver.resolve(Map.class, new Type[]{String.class, Object.class}), (Type)typeResolver.resolve(Object.class, new Type[0])));
        alternateTypeProvider.addRule(Alternates.newRule((Type)typeResolver.resolve(Map.class, new Type[]{Object.class, Object.class}), (Type)typeResolver.resolve(Object.class, new Type[0])));
        alternateTypeProvider.addRule(Alternates.newRule((Type)typeResolver.resolve(Map.class, new Type[]{String.class, String.class}), (Type)typeResolver.resolve(Object.class, new Type[0])));
        alternateTypeProvider.addRule(Alternates.newMapRule(WildcardType.class, WildcardType.class));
        return alternateTypeProvider;
    }

    @Bean
    public Map<RequestMethod, List<ResponseMessage>> defaultResponseMessages() {
        LinkedHashMap responses = Maps.newLinkedHashMap();
        responses.put(RequestMethod.GET, this.asList(new ResponseMessage(HttpStatus.OK.value(), HttpStatus.OK.getReasonPhrase(), ScalaUtils.toOption(null)), new ResponseMessage(HttpStatus.NOT_FOUND.value(), HttpStatus.NOT_FOUND.getReasonPhrase(), ScalaUtils.toOption(null)), new ResponseMessage(HttpStatus.FORBIDDEN.value(), HttpStatus.FORBIDDEN.getReasonPhrase(), ScalaUtils.toOption(null)), new ResponseMessage(HttpStatus.UNAUTHORIZED.value(), HttpStatus.UNAUTHORIZED.getReasonPhrase(), ScalaUtils.toOption(null))));
        responses.put(RequestMethod.PUT, this.asList(new ResponseMessage(HttpStatus.CREATED.value(), HttpStatus.CREATED.getReasonPhrase(), ScalaUtils.toOption(null)), new ResponseMessage(HttpStatus.NOT_FOUND.value(), HttpStatus.NOT_FOUND.getReasonPhrase(), ScalaUtils.toOption(null)), new ResponseMessage(HttpStatus.FORBIDDEN.value(), HttpStatus.FORBIDDEN.getReasonPhrase(), ScalaUtils.toOption(null)), new ResponseMessage(HttpStatus.UNAUTHORIZED.value(), HttpStatus.UNAUTHORIZED.getReasonPhrase(), ScalaUtils.toOption(null))));
        responses.put(RequestMethod.POST, this.asList(new ResponseMessage(HttpStatus.CREATED.value(), HttpStatus.CREATED.getReasonPhrase(), ScalaUtils.toOption(null)), new ResponseMessage(HttpStatus.NOT_FOUND.value(), HttpStatus.NOT_FOUND.getReasonPhrase(), ScalaUtils.toOption(null)), new ResponseMessage(HttpStatus.FORBIDDEN.value(), HttpStatus.FORBIDDEN.getReasonPhrase(), ScalaUtils.toOption(null)), new ResponseMessage(HttpStatus.UNAUTHORIZED.value(), HttpStatus.UNAUTHORIZED.getReasonPhrase(), ScalaUtils.toOption(null))));
        responses.put(RequestMethod.DELETE, this.asList(new ResponseMessage(HttpStatus.NO_CONTENT.value(), HttpStatus.CREATED.getReasonPhrase(), ScalaUtils.toOption(null)), new ResponseMessage(HttpStatus.FORBIDDEN.value(), HttpStatus.FORBIDDEN.getReasonPhrase(), ScalaUtils.toOption(null)), new ResponseMessage(HttpStatus.UNAUTHORIZED.value(), HttpStatus.UNAUTHORIZED.getReasonPhrase(), ScalaUtils.toOption(null))));
        responses.put(RequestMethod.PATCH, this.asList(new ResponseMessage(HttpStatus.NO_CONTENT.value(), HttpStatus.CREATED.getReasonPhrase(), ScalaUtils.toOption(null)), new ResponseMessage(HttpStatus.FORBIDDEN.value(), HttpStatus.FORBIDDEN.getReasonPhrase(), ScalaUtils.toOption(null)), new ResponseMessage(HttpStatus.UNAUTHORIZED.value(), HttpStatus.UNAUTHORIZED.getReasonPhrase(), ScalaUtils.toOption(null))));
        responses.put(RequestMethod.TRACE, this.asList(new ResponseMessage(HttpStatus.NO_CONTENT.value(), HttpStatus.CREATED.getReasonPhrase(), ScalaUtils.toOption(null)), new ResponseMessage(HttpStatus.FORBIDDEN.value(), HttpStatus.FORBIDDEN.getReasonPhrase(), ScalaUtils.toOption(null)), new ResponseMessage(HttpStatus.UNAUTHORIZED.value(), HttpStatus.UNAUTHORIZED.getReasonPhrase(), ScalaUtils.toOption(null))));
        responses.put(RequestMethod.OPTIONS, this.asList(new ResponseMessage(HttpStatus.NO_CONTENT.value(), HttpStatus.CREATED.getReasonPhrase(), ScalaUtils.toOption(null)), new ResponseMessage(HttpStatus.FORBIDDEN.value(), HttpStatus.FORBIDDEN.getReasonPhrase(), ScalaUtils.toOption(null)), new ResponseMessage(HttpStatus.UNAUTHORIZED.value(), HttpStatus.UNAUTHORIZED.getReasonPhrase(), ScalaUtils.toOption(null))));
        responses.put(RequestMethod.HEAD, this.asList(new ResponseMessage(HttpStatus.NO_CONTENT.value(), HttpStatus.CREATED.getReasonPhrase(), ScalaUtils.toOption(null)), new ResponseMessage(HttpStatus.FORBIDDEN.value(), HttpStatus.FORBIDDEN.getReasonPhrase(), ScalaUtils.toOption(null)), new ResponseMessage(HttpStatus.UNAUTHORIZED.value(), HttpStatus.UNAUTHORIZED.getReasonPhrase(), ScalaUtils.toOption(null))));
        return responses;
    }

    private List<ResponseMessage> asList(ResponseMessage ... responseMessages) {
        ArrayList<ResponseMessage> list = new ArrayList<ResponseMessage>();
        for (ResponseMessage responseMessage : responseMessages) {
            list.add(responseMessage);
        }
        return list;
    }

    public List<RequestMappingHandlerMapping> getHandlerMappings() {
        return this.handlerMappings;
    }
}

