/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.controllers;

import com.google.common.collect.Iterables;
import com.mangofactory.swagger.annotations.ApiIgnore;
import com.mangofactory.swagger.core.SwaggerCache;
import com.wordnik.swagger.model.ApiListing;
import com.wordnik.swagger.model.ResourceListing;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DefaultSwaggerController {
    public static final String DOCUMENTATION_BASE_PATH = "/api-docs";
    private static final String API_ROOT = "root";
    @Autowired
    private SwaggerCache swaggerCache;

    @ApiIgnore
    @RequestMapping(value={"/api-docs"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<ResourceListing> getResourceListingByKey() {
        return this.getSwaggerResourceListing(API_ROOT);
    }

    @ApiIgnore
    @RequestMapping(value={"/api-docs/{resource}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<ApiListing> getApiListing(@PathVariable String resource) {
        return this.getSwaggerApiListing(resource);
    }

    @ApiIgnore
    @RequestMapping(value={"/api-docs/{swaggerGroup}/{resource:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<ApiListing> getApiListing(@PathVariable String swaggerGroup, @PathVariable String resource) {
        return this.getSwaggerApiListing(resource);
    }

    private ResponseEntity<ApiListing> getSwaggerApiListing(String resource) {
        ResponseEntity responseEntity = new ResponseEntity(HttpStatus.NOT_FOUND);
        ApiListing apiListing = this.swaggerCache.getSwaggerApiListing(resource);
        if (null != apiListing) {
            responseEntity = new ResponseEntity((Object)apiListing, HttpStatus.OK);
        }
        return responseEntity;
    }

    private ResponseEntity<ResourceListing> getSwaggerResourceListing(String resourceKey) {
        ResponseEntity responseEntity = new ResponseEntity(HttpStatus.NOT_FOUND);
        ResourceListing resourceListing = null;
        if (API_ROOT.equals(resourceKey)) {
            resourceListing = (ResourceListing)Iterables.getFirst(this.swaggerCache.getSwaggerApiResourceListingMap().values(), null);
        } else if (this.swaggerCache.getSwaggerApiResourceListingMap().containsKey(resourceKey)) {
            resourceListing = this.swaggerCache.getSwaggerApiResourceListingMap().get(resourceKey);
        }
        if (null != resourceListing) {
            responseEntity = new ResponseEntity((Object)resourceListing, HttpStatus.OK);
        }
        return responseEntity;
    }
}

