/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.core;

import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mangofactory.swagger.ScalaUtils;
import com.mangofactory.swagger.authorization.AuthorizationContext;
import com.mangofactory.swagger.configuration.SwaggerGlobalSettings;
import com.mangofactory.swagger.core.SwaggerCache;
import com.mangofactory.swagger.core.SwaggerPathProvider;
import com.mangofactory.swagger.models.AccessorsProvider;
import com.mangofactory.swagger.models.DefaultModelPropertiesProvider;
import com.mangofactory.swagger.models.DefaultModelProvider;
import com.mangofactory.swagger.models.FieldsProvider;
import com.mangofactory.swagger.models.ModelDependencyProvider;
import com.mangofactory.swagger.models.ModelPropertiesProvider;
import com.mangofactory.swagger.models.ModelProvider;
import com.mangofactory.swagger.scanners.ApiListingReferenceScanner;
import com.mangofactory.swagger.scanners.ApiListingScanner;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import com.mangofactory.swagger.scanners.ResourceGroup;
import com.wordnik.swagger.core.SwaggerSpec;
import com.wordnik.swagger.model.ApiInfo;
import com.wordnik.swagger.model.ApiListing;
import com.wordnik.swagger.model.AuthorizationType;
import com.wordnik.swagger.model.ResourceListing;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerApiResourceListing {
    private static final Logger log = LoggerFactory.getLogger(SwaggerApiResourceListing.class);
    private SwaggerCache swaggerCache;
    private ApiInfo apiInfo;
    private List<AuthorizationType> authorizationTypes;
    private AuthorizationContext authorizationContext;
    private ApiListingReferenceScanner apiListingReferenceScanner;
    private SwaggerPathProvider swaggerPathProvider;
    private SwaggerGlobalSettings swaggerGlobalSettings;
    private String swaggerGroup;

    public SwaggerApiResourceListing(SwaggerCache swaggerCache, String swaggerGroup) {
        this.swaggerCache = swaggerCache;
        this.swaggerGroup = swaggerGroup;
    }

    @PostConstruct
    public void initialize() {
        List<Object> apiListingReferences = new ArrayList();
        if (null != this.apiListingReferenceScanner) {
            this.apiListingReferenceScanner.scan();
            apiListingReferences = this.apiListingReferenceScanner.getApiListingReferences();
            Map<ResourceGroup, List<RequestMappingContext>> resourceGroupRequestMappings = this.apiListingReferenceScanner.getResourceGroupRequestMappings();
            TypeResolver typeResolver = this.swaggerGlobalSettings.getTypeResolver();
            DefaultModelPropertiesProvider propertiesProvider = new DefaultModelPropertiesProvider(new ObjectMapper(), new AccessorsProvider(typeResolver), new FieldsProvider(typeResolver));
            ModelDependencyProvider dependencyProvider = new ModelDependencyProvider(typeResolver, (ModelPropertiesProvider)propertiesProvider);
            DefaultModelProvider modelProvider = new DefaultModelProvider(typeResolver, (ModelPropertiesProvider)propertiesProvider, dependencyProvider);
            ApiListingScanner apiListingScanner = new ApiListingScanner(resourceGroupRequestMappings, this.swaggerPathProvider, (ModelProvider)modelProvider, this.authorizationContext);
            apiListingScanner.setSwaggerGlobalSettings(this.swaggerGlobalSettings);
            Map<String, ApiListing> apiListings = apiListingScanner.scan();
            this.swaggerCache.addApiListings(apiListings);
        } else {
            log.error("ApiListingReferenceScanner not configured");
        }
        ResourceListing resourceListing = new ResourceListing("1", SwaggerSpec.version(), ScalaUtils.toScalaList(apiListingReferences), ScalaUtils.toScalaList(this.authorizationTypes), ScalaUtils.toOption(this.apiInfo));
        this.swaggerCache.addSwaggerResourceListing(this.swaggerGroup, resourceListing);
    }

    public SwaggerCache getSwaggerCache() {
        return this.swaggerCache;
    }

    public void setSwaggerCache(SwaggerCache swaggerCache) {
        this.swaggerCache = swaggerCache;
    }

    public ApiInfo getApiInfo() {
        return this.apiInfo;
    }

    public void setApiInfo(ApiInfo apiInfo) {
        this.apiInfo = apiInfo;
    }

    public List<AuthorizationType> getAuthorizationTypes() {
        return this.authorizationTypes;
    }

    public void setAuthorizationTypes(List<AuthorizationType> authorizationTypes) {
        this.authorizationTypes = authorizationTypes;
    }

    public ApiListingReferenceScanner getApiListingReferenceScanner() {
        return this.apiListingReferenceScanner;
    }

    public void setApiListingReferenceScanner(ApiListingReferenceScanner apiListingReferenceScanner) {
        this.apiListingReferenceScanner = apiListingReferenceScanner;
    }

    public SwaggerPathProvider getSwaggerPathProvider() {
        return this.swaggerPathProvider;
    }

    public void setSwaggerPathProvider(SwaggerPathProvider swaggerPathProvider) {
        this.swaggerPathProvider = swaggerPathProvider;
    }

    public SwaggerGlobalSettings getSwaggerGlobalSettings() {
        return this.swaggerGlobalSettings;
    }

    public void setSwaggerGlobalSettings(SwaggerGlobalSettings swaggerGlobalSettings) {
        this.swaggerGlobalSettings = swaggerGlobalSettings;
    }

    public String getSwaggerGroup() {
        return this.swaggerGroup;
    }

    public void setSwaggerGroup(String swaggerGroup) {
        this.swaggerGroup = swaggerGroup;
    }

    public void setAuthorizationContext(AuthorizationContext authorizationContext) {
        this.authorizationContext = authorizationContext;
    }
}

