/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.core;

import com.google.common.collect.Maps;
import com.wordnik.swagger.model.ApiListing;
import com.wordnik.swagger.model.ResourceListing;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class SwaggerCache {
    private Map<String, ResourceListing> swaggerApiResourceListingMap = Maps.newLinkedHashMap();
    private Map<String, ApiListing> swaggerApiListingMap = Maps.newHashMap();

    public void addSwaggerResourceListing(String swaggerGroup, ResourceListing resourceListing) {
        this.swaggerApiResourceListingMap.put(swaggerGroup, resourceListing);
    }

    public void addApiListings(Map<String, ApiListing> apiListings) {
        this.swaggerApiListingMap.putAll(apiListings);
    }

    public ResourceListing getResourceListing(String key) {
        return this.swaggerApiResourceListingMap.get(key);
    }

    public Map<String, ResourceListing> getSwaggerApiResourceListingMap() {
        return this.swaggerApiResourceListingMap;
    }

    public ApiListing getSwaggerApiListing(String key) {
        return this.swaggerApiListingMap.get(key);
    }
}

