/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.mangofactory.swagger.configuration.SwaggerGlobalSettings;
import com.mangofactory.swagger.core.ModelUtils;
import com.mangofactory.swagger.models.ModelContext;
import com.mangofactory.swagger.models.ModelProvider;
import com.mangofactory.swagger.models.ResolvedTypes;
import com.mangofactory.swagger.readers.Command;
import com.mangofactory.swagger.readers.operation.HandlerMethodResolver;
import com.mangofactory.swagger.readers.operation.ResolvedMethodParameter;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.model.Model;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.method.HandlerMethod;

@Component
public class ApiModelReader
implements Command<RequestMappingContext> {
    private static final Logger log = LoggerFactory.getLogger(ApiModelReader.class);
    private ModelProvider modelProvider;

    @Autowired
    public ApiModelReader(ModelProvider modelProvider) {
        this.modelProvider = modelProvider;
    }

    @Override
    public void execute(RequestMappingContext context) {
        HandlerMethod handlerMethod = context.getHandlerMethod();
        log.debug("Reading models for handlerMethod |{}|", (Object)handlerMethod.getMethod().getName());
        HashMap modelMap = Maps.newHashMap();
        SwaggerGlobalSettings swaggerGlobalSettings = (SwaggerGlobalSettings)context.get("swaggerGlobalSettings");
        HandlerMethodResolver handlerMethodResolver = new HandlerMethodResolver(swaggerGlobalSettings.getTypeResolver());
        ResolvedType modelType = ModelUtils.handlerReturnType(swaggerGlobalSettings.getTypeResolver(), handlerMethod);
        modelType = swaggerGlobalSettings.getAlternateTypeProvider().alternateFor(modelType);
        ApiOperation apiOperationAnnotation = (ApiOperation)handlerMethod.getMethodAnnotation(ApiOperation.class);
        if (null != apiOperationAnnotation && Void.class != apiOperationAnnotation.response()) {
            modelType = ResolvedTypes.asResolved((TypeResolver)swaggerGlobalSettings.getTypeResolver(), (Type)apiOperationAnnotation.response());
        }
        if (!swaggerGlobalSettings.getIgnorableParameterTypes().contains(modelType.getErasedType())) {
            ModelContext modelContext = ModelContext.returnValue((Type)modelType);
            this.markIgnorablesAsHasSeen(swaggerGlobalSettings.getIgnorableParameterTypes(), modelContext);
            Optional model = this.modelProvider.modelFor(modelContext);
            if (model.isPresent() && !"void".equals(((Model)model.get()).name())) {
                log.debug("Swagger generated parameter model id: {}, name: {}, schema: {} models", (Object)((Model)model.get()).id(), (Object)((Model)model.get()).name());
                modelMap.put(((Model)model.get()).id(), model.get());
            } else {
                log.debug("Swagger core did not find any models");
            }
            this.populateDependencies(modelContext, modelMap);
        }
        modelMap.putAll(this.readParametersApiModel(handlerMethodResolver, swaggerGlobalSettings, handlerMethod));
        log.debug("Finished reading models for handlerMethod |{}|", (Object)handlerMethod.getMethod().getName());
        context.put("models", modelMap);
    }

    private void markIgnorablesAsHasSeen(Set<Class> ignorableParameterTypes, ModelContext modelContext) {
        for (Class ignorableParameterType : ignorableParameterTypes) {
            modelContext.seen(ResolvedTypes.asResolved((TypeResolver)new TypeResolver(), (Type)ignorableParameterType));
        }
    }

    private Map<String, Model> readParametersApiModel(HandlerMethodResolver handlerMethodResolver, SwaggerGlobalSettings settings, HandlerMethod handlerMethod) {
        Method method = handlerMethod.getMethod();
        HashMap modelMap = Maps.newHashMap();
        log.debug("Reading parameters models for handlerMethod |{}|", (Object)handlerMethod.getMethod().getName());
        List<ResolvedMethodParameter> parameterTypes = handlerMethodResolver.methodParameters(handlerMethod);
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            Annotation[] pAnnotations;
            for (Annotation annotation : pAnnotations = annotations[i]) {
                if (!(annotation instanceof RequestBody)) continue;
                ResolvedMethodParameter pType = parameterTypes.get(i);
                if (settings.getIgnorableParameterTypes().contains(pType.getResolvedParameterType().getErasedType())) continue;
                ResolvedType modelType = settings.getAlternateTypeProvider().alternateFor(pType.getResolvedParameterType());
                ModelContext modelContext = ModelContext.inputParam((Type)modelType);
                this.markIgnorablesAsHasSeen(settings.getIgnorableParameterTypes(), modelContext);
                Optional pModel = this.modelProvider.modelFor(modelContext);
                if (pModel.isPresent()) {
                    log.debug("Swagger generated parameter model id: {}, name: {}, schema: {} models", (Object)((Model)pModel.get()).id(), (Object)((Model)pModel.get()).name());
                    modelMap.put(((Model)pModel.get()).id(), pModel.get());
                } else {
                    log.debug("Swagger core did not find any parameter models for {}", (Object)pType.getResolvedParameterType());
                }
                this.populateDependencies(modelContext, modelMap);
            }
        }
        log.debug("Finished reading parameters models for handlerMethod |{}|", (Object)handlerMethod.getMethod().getName());
        return modelMap;
    }

    private void populateDependencies(ModelContext modelContext, Map<String, Model> modelMap) {
        modelMap.putAll(this.modelProvider.dependencies(modelContext));
    }
}

