/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.mangofactory.swagger.readers.Command;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import com.wordnik.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.mvc.condition.ConsumesRequestCondition;
import org.springframework.web.servlet.mvc.condition.ProducesRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class MediaTypeReader
implements Command<RequestMappingContext> {
    @Override
    public void execute(RequestMappingContext context) {
        RequestMappingInfo requestMappingInfo = context.getRequestMappingInfo();
        ConsumesRequestCondition consumesCondition = requestMappingInfo.getConsumesCondition();
        ProducesRequestCondition producesRequestCondition = requestMappingInfo.getProducesCondition();
        Set consumesMediaTypes = consumesCondition.getConsumableMediaTypes();
        Set producesMediaTypes = producesRequestCondition.getProducibleMediaTypes();
        List<String> consumesList = this.toList(consumesMediaTypes);
        List<String> producesList = this.toList(producesMediaTypes);
        ApiOperation annotation = context.getApiOperationAnnotation();
        if (null != annotation && !StringUtils.isBlank((String)annotation.consumes())) {
            consumesList = this.asList(annotation.consumes());
        }
        if (null != annotation && !StringUtils.isBlank((String)annotation.produces())) {
            producesList = this.asList(annotation.produces());
        }
        context.put("consumes", consumesList);
        context.put("produces", producesList);
    }

    private List<String> asList(String mediaTypes) {
        return Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)mediaTypes);
    }

    private List<String> toList(Set<MediaType> mediaTypeSet) {
        ArrayList mediaTypes = Lists.newArrayList();
        for (MediaType mediaType : mediaTypeSet) {
            mediaTypes.add(mediaType.toString());
        }
        return mediaTypes;
    }
}

