/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.scanners;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mangofactory.swagger.ScalaUtils;
import com.mangofactory.swagger.authorization.AuthorizationContext;
import com.mangofactory.swagger.configuration.SwaggerGlobalSettings;
import com.mangofactory.swagger.core.CommandExecutor;
import com.mangofactory.swagger.core.ResourceGroupingStrategy;
import com.mangofactory.swagger.core.SpringGroupingStrategy;
import com.mangofactory.swagger.core.SwaggerPathProvider;
import com.mangofactory.swagger.models.ModelProvider;
import com.mangofactory.swagger.readers.ApiDescriptionReader;
import com.mangofactory.swagger.readers.ApiModelReader;
import com.mangofactory.swagger.readers.Command;
import com.mangofactory.swagger.readers.MediaTypeReader;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import com.mangofactory.swagger.scanners.ResourceGroup;
import com.wordnik.swagger.core.SwaggerSpec;
import com.wordnik.swagger.model.ApiDescription;
import com.wordnik.swagger.model.ApiListing;
import com.wordnik.swagger.model.Authorization;
import com.wordnik.swagger.model.Model;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;
import scala.Option;
import scala.collection.immutable.List;

public class ApiListingScanner {
    private static final Logger log = LoggerFactory.getLogger(ApiListingScanner.class);
    private String apiVersion = "1.0";
    private String swaggerVersion = SwaggerSpec.version();
    private Map<ResourceGroup, java.util.List<RequestMappingContext>> resourceGroupRequestMappings;
    private SwaggerPathProvider swaggerPathProvider;
    private java.util.List<Command<RequestMappingContext>> readers = Lists.newArrayList();
    private SwaggerGlobalSettings swaggerGlobalSettings;
    private ResourceGroupingStrategy controllerNamingStrategy;
    private AuthorizationContext authorizationContext;
    private final ModelProvider modelProvider;

    public ApiListingScanner(Map<ResourceGroup, java.util.List<RequestMappingContext>> resourceGroupRequestMappings, SwaggerPathProvider swaggerPathProvider, ModelProvider modelProvider, AuthorizationContext authorizationContext) {
        this.resourceGroupRequestMappings = resourceGroupRequestMappings;
        this.swaggerPathProvider = swaggerPathProvider;
        this.authorizationContext = authorizationContext;
        this.modelProvider = modelProvider;
    }

    public Map<String, ApiListing> scan() {
        if (null == this.controllerNamingStrategy) {
            this.controllerNamingStrategy = new SpringGroupingStrategy();
        }
        HashMap apiListingMap = Maps.newHashMap();
        int position = 0;
        for (Map.Entry<ResourceGroup, java.util.List<RequestMappingContext>> entry : this.resourceGroupRequestMappings.entrySet()) {
            ResourceGroup controllerGroup = entry.getKey();
            LinkedHashSet produces = new LinkedHashSet(2);
            LinkedHashSet consumes = new LinkedHashSet(2);
            HashSet apiDescriptions = Sets.newHashSet();
            LinkedHashMap<String, Model> models = new LinkedHashMap<String, Model>();
            for (RequestMappingContext each : entry.getValue()) {
                CommandExecutor commandExecutor = new CommandExecutor();
                each.put("authorizationContext", this.authorizationContext);
                this.readers.add(new MediaTypeReader());
                this.readers.add(new ApiDescriptionReader(this.swaggerPathProvider));
                this.readers.add(new ApiModelReader(this.modelProvider));
                each.put("swaggerGlobalSettings", this.swaggerGlobalSettings);
                Map<String, Object> results = commandExecutor.execute(this.readers, each);
                java.util.List producesMediaTypes = (java.util.List)results.get("produces");
                java.util.List consumesMediaTypes = (java.util.List)results.get("consumes");
                Map swaggerModels = (Map)results.get("models");
                if (null != swaggerModels) {
                    models.putAll(swaggerModels);
                }
                produces.addAll(producesMediaTypes);
                consumes.addAll(consumesMediaTypes);
                java.util.List apiDescriptionList = (java.util.List)results.get("apiDescriptionList");
                apiDescriptions.addAll(apiDescriptionList);
            }
            String resourcePath = UriComponentsBuilder.fromPath((String)this.swaggerPathProvider.getApiResourcePrefix()).pathSegment(new String[]{controllerGroup.getGroupName()}).build().toString();
            List<Authorization> authorizations = ScalaUtils.emptyScalaList();
            if (null != this.authorizationContext) {
                authorizations = this.authorizationContext.getScalaAuthorizations();
            }
            Option modelOption = ScalaUtils.toOption(models);
            if (null != models) {
                modelOption = ScalaUtils.toOption(ScalaUtils.toScalaModelMap(models));
            }
            String groupPrefix = String.format("%s%s", this.swaggerPathProvider.getApiResourcePrefix(), controllerGroup.getRealUri());
            ApiListing apiListing = new ApiListing(this.apiVersion, this.swaggerVersion, this.swaggerPathProvider.getAppBasePath(), resourcePath, ScalaUtils.toScalaList(produces), ScalaUtils.toScalaList(consumes), ScalaUtils.emptyScalaList(), authorizations, ScalaUtils.toScalaList(Sets.filter((Set)apiDescriptions, this.withPathBeginning(groupPrefix))), modelOption, ScalaUtils.toOption(null), position++);
            apiListingMap.put(controllerGroup.getGroupName(), apiListing);
        }
        return apiListingMap;
    }

    private Predicate<? super ApiDescription> withPathBeginning(final String path) {
        return new Predicate<ApiDescription>(){

            public boolean apply(ApiDescription input) {
                return input.path().startsWith(path);
            }
        };
    }

    public SwaggerGlobalSettings getSwaggerGlobalSettings() {
        return this.swaggerGlobalSettings;
    }

    public void setSwaggerGlobalSettings(SwaggerGlobalSettings swaggerGlobalSettings) {
        this.swaggerGlobalSettings = swaggerGlobalSettings;
    }

    public java.util.List<Command<RequestMappingContext>> getReaders() {
        return this.readers;
    }

    public void setReaders(java.util.List<Command<RequestMappingContext>> readers) {
        this.readers = readers;
    }

    public ResourceGroupingStrategy getControllerNamingStrategy() {
        return this.controllerNamingStrategy;
    }

    public void setControllerNamingStrategy(ResourceGroupingStrategy controllerNamingStrategy) {
        this.controllerNamingStrategy = controllerNamingStrategy;
    }

    public AuthorizationContext getAuthorizationContext() {
        return this.authorizationContext;
    }

    public void setAuthorizationContext(AuthorizationContext authorizationContext) {
        this.authorizationContext = authorizationContext;
    }
}

